/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.iso9660;

import com.github.stephenc.javaisotools.iso9660.ConfigException;
import com.github.stephenc.javaisotools.iso9660.ISO9660File;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class StandardConfig {
    String systemID = "";
    String volumeID = "";
    String volumeSetID = "";
    Object publisher = null;
    Object dataPreparer = null;
    Object app = null;
    Date createDate;
    Date modDate = this.createDate = new Date();
    Date expireDate = null;
    Date effectiveDate = this.createDate;
    ISO9660File abstractFile;
    ISO9660File bibFile;
    ISO9660File copyrightFile;
    int volSeqNo = 1;
    int volSetSize = 1;

    public List<ISO9660File> getFiles() {
        ArrayList<ISO9660File> files = new ArrayList<ISO9660File>();
        if (this.publisher instanceof ISO9660File) {
            files.add((ISO9660File)this.publisher);
        }
        if (this.dataPreparer instanceof ISO9660File) {
            files.add((ISO9660File)this.dataPreparer);
        }
        if (this.app instanceof ISO9660File) {
            files.add((ISO9660File)this.app);
        }
        files.add(this.abstractFile);
        files.add(this.bibFile);
        files.add(this.copyrightFile);
        return files;
    }

    public ISO9660File getAbstractFile() {
        return this.abstractFile;
    }

    public void setAbstractFile(File abstractFile) throws HandlerException {
        this.abstractFile = new ISO9660File(abstractFile);
    }

    public ISO9660File getBibFile() {
        return this.bibFile;
    }

    public void setBibFile(File bibFile) throws HandlerException {
        this.bibFile = new ISO9660File(bibFile);
    }

    public ISO9660File getCopyrightFile() {
        return this.copyrightFile;
    }

    public void setCopyrightFile(File copyrightFile) throws HandlerException {
        this.copyrightFile = new ISO9660File(copyrightFile);
    }

    public int getVolumeSequenceNumber() {
        return this.volSeqNo;
    }

    public void setVolumeSequenceNumber(int volSeqNo) throws ConfigException {
        if (volSeqNo < 1 || volSeqNo > 65535) {
            throw new ConfigException(this, "The Volume Sequence Number must be a positive integer.");
        }
        this.volSeqNo = volSeqNo;
    }

    public String getVolumeSetID() {
        return this.volumeSetID;
    }

    public void setVolumeSetID(String volumeSetID) throws ConfigException {
        if (volumeSetID.length() > 128) {
            throw new ConfigException(this, "The Volume Set ID may be no longer than 128 characters.");
        }
        this.volumeSetID = volumeSetID;
    }

    public int getVolumeSetSize() {
        return this.volSetSize;
    }

    public void setVolumeSetSize(int volSetSize) throws ConfigException {
        if (volSetSize < 1 || volSetSize > 65535) {
            throw new ConfigException(this, "The Volume Set Size must be a positive integer.");
        }
        this.volSetSize = volSetSize;
    }

    public Object getApp() {
        return this.app;
    }

    public void setApp(String app) throws ConfigException {
        if (app.length() > 128) {
            throw new ConfigException(this, "The Application Identifier may be no longer than 128 characters.");
        }
        this.app = app;
    }

    public void setApp(File app) throws HandlerException {
        this.app = new ISO9660File(app);
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Object getDataPreparer() {
        return this.dataPreparer;
    }

    public void setDataPreparer(String dataPreparer) throws ConfigException {
        if (dataPreparer.length() > 128) {
            throw new ConfigException(this, "The Data Preparer Identifier may be no longer than 128 characters.");
        }
        this.dataPreparer = dataPreparer;
    }

    public void setDataPreparer(File dataPreparer) throws HandlerException {
        this.dataPreparer = new ISO9660File(dataPreparer);
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Date getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(Date expireDate) {
        this.expireDate = expireDate;
    }

    public Date getModDate() {
        return this.modDate;
    }

    public void setModDate(Date modDate) {
        this.modDate = modDate;
    }

    public Object getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) throws ConfigException {
        if (publisher.length() > 128) {
            throw new ConfigException(this, "The Publisher Identifier may be no longer than 128 characters.");
        }
        this.publisher = publisher;
    }

    public void setPublisher(File publisher) throws HandlerException {
        this.publisher = new ISO9660File(publisher);
    }

    public String getSystemID() {
        return this.systemID;
    }

    public void setSystemID(String systemID) throws ConfigException {
        if (systemID.length() > 32) {
            throw new ConfigException(this, "The System Identifier may be no longer than 32 characters.");
        }
        this.systemID = systemID;
    }

    public String getVolumeID() {
        return this.volumeID;
    }

    public void setVolumeID(String volumeID) throws ConfigException {
        if (volumeID.length() > 32) {
            throw new ConfigException(this, "The Volume Identifier may be no longer than 32 characters.");
        }
        this.volumeID = volumeID;
    }
}

