/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.impl;

import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.Attributes;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.NameScope;
import org.apache.commons.vfs.impl.Resource;

public class VFSClassLoader
extends SecureClassLoader {
    private final ArrayList resources = new ArrayList();

    public VFSClassLoader(FileObject file, FileSystemManager manager) throws FileSystemException {
        this(new FileObject[]{file}, manager, null);
    }

    public VFSClassLoader(FileObject file, FileSystemManager manager, ClassLoader parent) throws FileSystemException {
        this(new FileObject[]{file}, manager, parent);
    }

    public VFSClassLoader(FileObject[] files, FileSystemManager manager) throws FileSystemException {
        this(files, manager, null);
    }

    public VFSClassLoader(FileObject[] files, FileSystemManager manager, ClassLoader parent) throws FileSystemException {
        super(parent);
        this.addFileObjects(manager, files);
    }

    private void addFileObjects(FileSystemManager manager, FileObject[] files) throws FileSystemException {
        for (int i2 = 0; i2 < files.length; ++i2) {
            FileObject file = files[i2];
            if (!file.exists()) continue;
            if (manager.canCreateFileSystem(file)) {
                file = manager.createFileSystem(file);
            }
            this.resources.add(file);
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        try {
            String path = name.replace('.', '/').concat(".class");
            Resource res = this.loadResource(path);
            if (res == null) {
                throw new ClassNotFoundException(name);
            }
            return this.defineClass(name, res);
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(name, ioe);
        }
    }

    private Class defineClass(String name, Resource res) throws IOException {
        URL url = res.getCodeSourceURL();
        String pkgName = res.getPackageName();
        if (pkgName != null) {
            Package pkg = this.getPackage(pkgName);
            if (pkg != null) {
                if (pkg.isSealed()) {
                    if (!pkg.isSealed(url)) {
                        throw new FileSystemException("vfs.impl/pkg-sealed-other-url", pkgName);
                    }
                } else if (this.isSealed(res)) {
                    throw new FileSystemException("vfs.impl/pkg-sealing-unsealed", pkgName);
                }
            } else {
                this.definePackage(pkgName, res);
            }
        }
        byte[] bytes = res.getBytes();
        Certificate[] certs = res.getFileObject().getContent().getCertificates();
        CodeSource cs = new CodeSource(url, certs);
        return this.defineClass(name, bytes, 0, bytes.length, cs);
    }

    private boolean isSealed(Resource res) throws FileSystemException {
        String sealed = res.getPackageAttribute(Attributes.Name.SEALED);
        return "true".equalsIgnoreCase(sealed);
    }

    private Package definePackage(String name, Resource res) throws FileSystemException {
        String specTitle = res.getPackageAttribute(Attributes.Name.SPECIFICATION_TITLE);
        String specVendor = res.getPackageAttribute(Attributes.Name.SPECIFICATION_VENDOR);
        String specVersion = res.getPackageAttribute(Attributes.Name.SPECIFICATION_VERSION);
        String implTitle = res.getPackageAttribute(Attributes.Name.IMPLEMENTATION_TITLE);
        String implVendor = res.getPackageAttribute(Attributes.Name.IMPLEMENTATION_VENDOR);
        String implVersion = res.getPackageAttribute(Attributes.Name.IMPLEMENTATION_VERSION);
        URL sealBase = this.isSealed(res) ? res.getCodeSourceURL() : null;
        return this.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    protected PermissionCollection getPermissions(CodeSource cs) {
        try {
            String url = cs.getLocation().toString();
            FileObject file = this.lookupFileObject(url);
            if (file == null) {
                return super.getPermissions(cs);
            }
            FileObject parentLayer = file.getFileSystem().getParentLayer();
            if (parentLayer == null) {
                return super.getPermissions(cs);
            }
            Permissions combi = new Permissions();
            PermissionCollection permCollect = super.getPermissions(cs);
            this.copyPermissions(permCollect, combi);
            FileObject parent = parentLayer;
            while (parent != null) {
                CodeSource parentcs = new CodeSource(parent.getURL(), parent.getContent().getCertificates());
                permCollect = super.getPermissions(parentcs);
                this.copyPermissions(permCollect, combi);
                parent = parent.getFileSystem().getParentLayer();
            }
            return combi;
        }
        catch (FileSystemException fse) {
            throw new SecurityException(fse.getMessage());
        }
    }

    protected void copyPermissions(PermissionCollection src, PermissionCollection dest) {
        Enumeration<Permission> elem = src.elements();
        while (elem.hasMoreElements()) {
            Permission permission = elem.nextElement();
            dest.add(permission);
        }
    }

    private FileObject lookupFileObject(String name) {
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            FileObject object = (FileObject)it.next();
            if (!name.equals(object.getName().getURI())) continue;
            return object;
        }
        return null;
    }

    protected URL findResource(String name) {
        try {
            Resource res = this.loadResource(name);
            if (res != null) {
                return res.getURL();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected Enumeration findResources(String name) {
        return new Enumeration(){

            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() {
                return null;
            }
        };
    }

    private Resource loadResource(String name) throws FileSystemException {
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            FileObject baseFile = (FileObject)it.next();
            FileObject file = baseFile.resolveFile(name, NameScope.DESCENDENT_OR_SELF);
            if (!file.exists()) continue;
            return new Resource(name, baseFile, file);
        }
        return null;
    }
}

