/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.ram;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.ram.RamFileObject;

public class RamFileOutputStream
extends OutputStream {
    protected RamFileObject file;
    protected byte[] buffer1 = new byte[1];
    protected boolean closed = false;
    private IOException exc;

    public RamFileOutputStream(RamFileObject file) {
        this.file = file;
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        int size = this.file.getData().size();
        int newSize = this.file.getData().size() + len;
        try {
            this.file.resize(newSize);
        }
        catch (IOException e2) {
            this.exc = e2;
            throw e2;
        }
        System.arraycopy(b2, off, this.file.getData().getBuffer(), size, len);
    }

    public void write(int b2) throws IOException {
        this.buffer1[0] = (byte)b2;
        this.write(this.buffer1);
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.exc != null) {
            throw this.exc;
        }
        try {
            this.closed = true;
            this.file.endOutput();
        }
        catch (Exception e2) {
            throw new FileSystemException(e2);
        }
    }
}

