/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.temp;

import java.io.File;
import java.util.Collection;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileProvider;
import org.apache.commons.vfs.provider.FileProvider;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.local.DefaultLocalFileProvider;
import org.apache.commons.vfs.provider.local.LocalFileSystem;

public class TemporaryFileProvider
extends AbstractFileProvider
implements FileProvider,
Comparable {
    private File rootFile;

    public TemporaryFileProvider(File rootFile) {
        this();
        this.rootFile = rootFile;
    }

    public TemporaryFileProvider() {
    }

    public int compareTo(Object o2) {
        int h2;
        int h1 = this.hashCode();
        if (h1 < (h2 = o2.hashCode())) {
            return -1;
        }
        if (h1 > h2) {
            return 1;
        }
        return 0;
    }

    public synchronized FileObject findFile(FileObject baseFile, String uri, FileSystemOptions properties) throws FileSystemException {
        StringBuffer buffer = new StringBuffer(uri);
        String scheme = UriParser.extractScheme(uri, buffer);
        UriParser.fixSeparators(buffer);
        FileType fileType = UriParser.normalisePath(buffer);
        String path = buffer.toString();
        FileSystem filesystem = this.findFileSystem(this, properties);
        if (filesystem == null) {
            if (this.rootFile == null) {
                this.rootFile = this.getContext().getTemporaryFileStore().allocateFile("tempfs");
            }
            FileName rootName = this.getContext().parseURI(scheme + ":" + "/");
            filesystem = new LocalFileSystem(rootName, this.rootFile.getAbsolutePath(), properties);
            this.addFileSystem(this, filesystem);
        }
        return filesystem.resolveFile(path);
    }

    public Collection getCapabilities() {
        return DefaultLocalFileProvider.capabilities;
    }
}

