/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.tasks;

import org.apache.commons.logging.Log;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.impl.StandardFileSystemManager;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.SubBuildListener;
import org.apache.tools.ant.Task;

public class VfsTask
extends Task {
    private static StandardFileSystemManager manager;

    protected FileObject resolveFile(String uri) throws FileSystemException {
        if (manager == null) {
            manager = new StandardFileSystemManager();
            manager.setLogger(new AntLogger());
            manager.init();
            this.getProject().addBuildListener((BuildListener)new CloseListener());
        }
        return manager.resolveFile(this.getProject().getBaseDir(), uri);
    }

    protected void closeManager() {
        if (manager != null) {
            manager.close();
            manager = null;
        }
    }

    private class AntLogger
    implements Log {
        private AntLogger() {
        }

        public void debug(Object o2) {
            VfsTask.this.log(String.valueOf(o2), 4);
        }

        public void debug(Object o2, Throwable throwable) {
            this.debug(o2);
        }

        public void error(Object o2) {
            VfsTask.this.log(String.valueOf(o2), 0);
        }

        public void error(Object o2, Throwable throwable) {
            this.error(o2);
        }

        public void fatal(Object o2) {
            VfsTask.this.log(String.valueOf(o2), 0);
        }

        public void fatal(Object o2, Throwable throwable) {
            this.fatal(o2);
        }

        public void info(Object o2) {
            VfsTask.this.log(String.valueOf(o2), 2);
        }

        public void info(Object o2, Throwable throwable) {
            this.info(o2);
        }

        public void trace(Object o2) {
        }

        public void trace(Object o2, Throwable throwable) {
        }

        public void warn(Object o2) {
            VfsTask.this.log(String.valueOf(o2), 1);
        }

        public void warn(Object o2, Throwable throwable) {
            this.warn(o2);
        }

        public boolean isDebugEnabled() {
            return true;
        }

        public boolean isErrorEnabled() {
            return true;
        }

        public boolean isFatalEnabled() {
            return true;
        }

        public boolean isInfoEnabled() {
            return true;
        }

        public boolean isTraceEnabled() {
            return false;
        }

        public boolean isWarnEnabled() {
            return true;
        }
    }

    private class CloseListener
    implements SubBuildListener {
        private CloseListener() {
        }

        public void subBuildStarted(BuildEvent buildEvent) {
        }

        public void subBuildFinished(BuildEvent buildEvent) {
            VfsTask.this.closeManager();
        }

        public void buildFinished(BuildEvent event) {
            VfsTask.this.closeManager();
        }

        public void buildStarted(BuildEvent event) {
        }

        public void messageLogged(BuildEvent event) {
        }

        public void targetFinished(BuildEvent event) {
        }

        public void targetStarted(BuildEvent event) {
        }

        public void taskFinished(BuildEvent event) {
        }

        public void taskStarted(BuildEvent event) {
        }
    }
}

