/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.action;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;

public class OpenBrowserAction
extends AbstractAction {
    private static Logger log = Logger.getLogger(OpenBrowserAction.class.getName());
    private URI uri;

    public OpenBrowserAction() {
        this((URI)null);
    }

    public OpenBrowserAction(String uri) {
        this(URI.create(uri));
    }

    public OpenBrowserAction(URL url) throws URISyntaxException {
        this(url.toURI());
    }

    public OpenBrowserAction(URI uri) {
        this.setURI(uri);
    }

    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public void actionPerformed(ActionEvent e2) {
        if (this.uri == null || !Desktop.isDesktopSupported()) {
            return;
        }
        if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(this.uri);
            }
            catch (IOException ioe) {
                log.log(Level.WARNING, "unable to browse: " + this.uri, ioe);
            }
        }
    }
}

