/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.rollover;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.rollover.RolloverController;
import org.jdesktop.swingx.rollover.RolloverRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableRolloverController<T extends JTable>
extends RolloverController<T> {
    private Cursor oldCursor;

    @Override
    protected void rollover(Point oldLocation, Point newLocation) {
        boolean paintOldRow = this.hasRow(oldLocation);
        boolean paintNewRow = this.hasRow(newLocation);
        if (paintOldRow && paintNewRow && oldLocation.y == newLocation.y) {
            paintOldRow = false;
            paintNewRow = false;
        }
        boolean paintOldColumn = this.hasColumn(oldLocation);
        boolean paintNewColumn = this.hasColumn(newLocation);
        if (paintOldColumn && paintNewColumn && oldLocation.x == newLocation.x) {
            paintOldColumn = false;
            paintNewColumn = false;
        }
        List<Rectangle> rectangles = this.getPaintRectangles(null, oldLocation, paintOldRow, paintOldColumn);
        if ((rectangles = this.getPaintRectangles(rectangles, newLocation, paintNewRow, paintNewColumn)) != null) {
            for (Rectangle rectangle : rectangles) {
                ((JTable)this.component).repaint(rectangle);
            }
        }
        this.setRolloverCursor(newLocation);
    }

    private List<Rectangle> getPaintRectangles(List<Rectangle> rectangles, Point cellLocation, boolean paintRow, boolean paintColumn) {
        if (!paintRow && !paintColumn) {
            return rectangles;
        }
        if (rectangles == null) {
            rectangles = new ArrayList<Rectangle>();
        }
        Rectangle r2 = ((JTable)this.component).getCellRect(cellLocation.y, cellLocation.x, false);
        if (paintRow) {
            rectangles.add(new Rectangle(0, r2.y, ((JTable)this.component).getWidth(), r2.height));
        }
        if (paintColumn) {
            rectangles.add(new Rectangle(r2.x, 0, r2.width, ((JTable)this.component).getHeight()));
        }
        return rectangles;
    }

    private boolean hasColumn(Point cellLocation) {
        return cellLocation != null && cellLocation.x >= 0;
    }

    private boolean hasRow(Point cellLocation) {
        return cellLocation != null && cellLocation.y >= 0;
    }

    @Override
    protected boolean isClickable(Point location) {
        return super.isClickable(location) && !((JTable)this.component).isCellEditable(location.y, location.x);
    }

    @Override
    protected RolloverRenderer getRolloverRenderer(Point location, boolean prepare) {
        RolloverRenderer rollover;
        TableCellRenderer renderer = ((JTable)this.component).getCellRenderer(location.y, location.x);
        RolloverRenderer rolloverRenderer = rollover = renderer instanceof RolloverRenderer ? (RolloverRenderer)((Object)renderer) : null;
        if (rollover != null && !rollover.isEnabled()) {
            rollover = null;
        }
        if (rollover != null && prepare) {
            ((JTable)this.component).prepareRenderer(renderer, location.y, location.x);
        }
        return rollover;
    }

    private void setRolloverCursor(Point location) {
        if (this.hasRollover(location)) {
            if (this.oldCursor == null) {
                this.oldCursor = ((JTable)this.component).getCursor();
                ((JTable)this.component).setCursor(Cursor.getPredefinedCursor(12));
            }
        } else if (this.oldCursor != null) {
            ((JTable)this.component).setCursor(this.oldCursor);
            this.oldCursor = null;
        }
    }

    @Override
    protected Point getFocusedCell() {
        int leadRow = ((JTable)this.component).getSelectionModel().getLeadSelectionIndex();
        int leadColumn = ((JTable)this.component).getColumnModel().getSelectionModel().getLeadSelectionIndex();
        return new Point(leadColumn, leadRow);
    }
}

