/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.iso9660;

import com.github.stephenc.javaisotools.iso9660.ISO9660Directory;
import com.github.stephenc.javaisotools.iso9660.ISO9660File;
import com.github.stephenc.javaisotools.iso9660.ISO9660HierarchyObject;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public abstract class NamingConventions {
    public static boolean VERBOSE = false;
    private static HashMap extensionMapper;
    private String id;

    public NamingConventions(String id) {
        this.id = id;
        NamingConventions.addExtensionMapping("tar.gz", "tgz");
        NamingConventions.addExtensionMapping("tar.bz2", "tbz");
    }

    public String getID() {
        return this.id;
    }

    public static void addExtensionMapping(String extension, String mapping) {
        if (extensionMapper == null) {
            extensionMapper = new HashMap();
        }
        if (!extensionMapper.containsKey(extension)) {
            extensionMapper.put(extension, mapping);
        }
    }

    public static String getExtensionMapping(String extension) {
        if (extensionMapper == null) {
            return null;
        }
        return (String)extensionMapper.get(extension);
    }

    public void startRenaming(ISO9660Directory dir) {
        if (VERBOSE) {
            System.out.print(this.id + ": Renamed directory " + dir.getISOPath());
        }
    }

    public void startRenaming(ISO9660File file) {
        if (VERBOSE) {
            System.out.print(this.id + ": Renamed file " + file.getISOPath());
        }
    }

    public void endRenaming(ISO9660Directory dir) {
        if (VERBOSE) {
            System.out.println(" to " + dir.getName());
        }
    }

    public void endRenaming(ISO9660File file) {
        if (VERBOSE) {
            System.out.println(" to " + file.getFullName());
        }
    }

    public void setFilename(ISO9660Directory dir, String filename) {
        if (!filename.equals(dir.getName())) {
            this.startRenaming(dir);
            dir.setName(filename);
            this.endRenaming(dir);
        }
    }

    public void setFilename(ISO9660File file, String filename) {
        if (!filename.equals(file.getFilename())) {
            this.startRenaming(file);
            file.setFilename(filename);
            this.endRenaming(file);
        }
    }

    public void setFilename(ISO9660File file, String filename, String extension) {
        if (!filename.equals(file.getFilename()) || !extension.equals(file.getExtension())) {
            this.startRenaming(file);
            file.setFilename(filename);
            file.setExtension(extension);
            this.endRenaming(file);
        }
    }

    public void incrementFilename(ISO9660Directory dir) throws HandlerException {
        String filename = dir.getName();
        if (filename.length() > 0) {
            int position;
            int number = -1;
            for (position = filename.length() - 1; position >= 0; --position) {
                try {
                    number = Integer.parseInt(filename.substring(position, filename.length()));
                    continue;
                }
                catch (NumberFormatException e2) {
                    // empty catch block
                    break;
                }
            }
            if (number >= 0) {
                filename = position > 0 ? filename.substring(0, position + 1) : "";
                filename = filename + ++number;
            } else {
                ISO9660Directory copy = new ISO9660Directory(filename + "2");
                this.apply(copy);
                filename = this.checkFilenameEquality(copy.getName(), filename) ? filename.substring(0, filename.length()) + "2" : copy.getName();
            }
        } else {
            filename = "2";
        }
        this.setFilename(dir, filename);
    }

    public void incrementFilename(ISO9660File file) throws HandlerException {
        String filename = file.getFilename();
        if (filename.length() > 0) {
            int position;
            int number = -1;
            for (position = filename.length() - 1; position >= 0; --position) {
                try {
                    number = Integer.parseInt(filename.substring(position, filename.length()));
                    continue;
                }
                catch (NumberFormatException e2) {
                    // empty catch block
                    break;
                }
            }
            if (number >= 0) {
                filename = position > 0 ? filename.substring(0, position + 1) : "";
                filename = filename + ++number;
            } else {
                ISO9660File copy = null;
                try {
                    copy = new ISO9660File(file);
                }
                catch (HandlerException e3) {
                    e3.printStackTrace();
                }
                this.apply(copy);
                filename = this.checkFilenameEquality(copy.getFilename(), filename) ? filename.substring(0, filename.length()) + "2" : copy.getFilename();
            }
        } else {
            filename = "2";
        }
        this.setFilename(file, filename);
    }

    public boolean checkFilenameEquality(String name1, String name2) {
        return name1.equals(name2);
    }

    public void processDirectory(ISO9660Directory dir) throws HandlerException {
        ArrayList<String[]> duplicates = new ArrayList<String[]>();
        ArrayList<ISO9660HierarchyObject> contents = new ArrayList<ISO9660HierarchyObject>();
        contents.addAll(dir.getDirectories());
        contents.addAll(dir.getFiles());
        Collections.sort(contents);
        for (ISO9660HierarchyObject object : contents) {
            boolean duplicate = false;
            if (object instanceof ISO9660Directory) {
                ISO9660Directory subdir = (ISO9660Directory)object;
                this.apply(subdir);
                while (this.checkDuplicate(duplicates, subdir.getName(), -1)) {
                    this.incrementFilename(subdir);
                    duplicate = true;
                }
                if (!duplicate) {
                    duplicates.clear();
                }
                this.addDuplicate(duplicates, subdir.getName(), -1);
                this.checkPathLength(subdir.getISOPath());
                continue;
            }
            if (object instanceof ISO9660File) {
                ISO9660File file = (ISO9660File)object;
                this.apply(file);
                while (this.checkDuplicate(duplicates, file.getName(), file.getVersion())) {
                    this.incrementFilename(file);
                    duplicate = true;
                }
                if (!duplicate) {
                    duplicates.clear();
                }
                this.addDuplicate(duplicates, file.getName(), file.getVersion());
                this.checkPathLength(file.getISOPath());
                continue;
            }
            throw new HandlerException("Neither file nor directory: " + object);
        }
    }

    public boolean checkDuplicate(List<String[]> duplicates, String name, int version) {
        return this.checkDuplicate(duplicates, name, version, true);
    }

    public boolean checkDuplicate(List<String[]> duplicates, String name, int version, boolean checkVersion) {
        for (String[] data : duplicates) {
            if (!this.checkFilenameEquality(data[0], name)) continue;
            int aVersion = Integer.parseInt(data[1]);
            if (checkVersion && aVersion != -1 && version != aVersion) continue;
            return true;
        }
        return false;
    }

    public void addDuplicate(List<String[]> duplicates, String name, int version) {
        String[] data = new String[]{name, version + ""};
        duplicates.add(data);
    }

    public abstract void apply(ISO9660Directory var1) throws HandlerException;

    public abstract void apply(ISO9660File var1) throws HandlerException;

    public abstract void checkPathLength(String var1);
}

