/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.iso9660.impl;

import com.github.stephenc.javaisotools.eltorito.impl.ElToritoConfig;
import com.github.stephenc.javaisotools.eltorito.impl.ElToritoHandler;
import com.github.stephenc.javaisotools.iso9660.ISO9660RootDirectory;
import com.github.stephenc.javaisotools.iso9660.impl.FileHandler;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660Config;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660Element;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660Handler;
import com.github.stephenc.javaisotools.iso9660.impl.LogicalSectorPaddingHandler;
import com.github.stephenc.javaisotools.joliet.impl.JolietConfig;
import com.github.stephenc.javaisotools.joliet.impl.JolietHandler;
import com.github.stephenc.javaisotools.rockridge.impl.RockRidgeConfig;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;
import java.io.FileNotFoundException;

public class CreateISO {
    private ISO9660RootDirectory root;
    private StreamHandler streamHandler;

    public CreateISO(StreamHandler streamHandler, ISO9660RootDirectory root) throws FileNotFoundException {
        this.streamHandler = new LogicalSectorPaddingHandler(streamHandler, streamHandler);
        this.root = root;
    }

    public void process(ISO9660Config iso9660Config, RockRidgeConfig rrConfig, JolietConfig jolietConfig, ElToritoConfig elToritoConfig) throws HandlerException {
        if (iso9660Config == null) {
            throw new NullPointerException("Cannot create ISO without ISO9660Config.");
        }
        ((LogicalSectorPaddingHandler)this.streamHandler).setPadEnd(iso9660Config.getPadEnd());
        if (jolietConfig != null) {
            this.streamHandler = new JolietHandler(this.streamHandler, this.root, jolietConfig);
        }
        if (elToritoConfig != null) {
            this.streamHandler = new ElToritoHandler(this.streamHandler, elToritoConfig);
        }
        this.streamHandler = new ISO9660Handler(this.streamHandler, this.root, iso9660Config, rrConfig);
        this.streamHandler = new FileHandler(this.streamHandler, this.root);
        this.streamHandler.startDocument();
        this.streamHandler.startElement(new ISO9660Element("SA"));
        this.streamHandler.endElement();
        this.streamHandler.startElement(new ISO9660Element("VDS"));
        this.streamHandler.endElement();
        this.streamHandler.startElement(new ISO9660Element("BIA"));
        this.streamHandler.endElement();
        this.streamHandler.startElement(new ISO9660Element("PTA"));
        this.streamHandler.endElement();
        this.streamHandler.startElement(new ISO9660Element("DRA"));
        this.streamHandler.endElement();
        this.streamHandler.startElement(new ISO9660Element("BDA"));
        this.streamHandler.endElement();
        this.streamHandler.startElement(new ISO9660Element("FCA"));
        this.streamHandler.endElement();
        this.streamHandler.endDocument();
    }
}

