/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.iso9660.impl;

import com.github.stephenc.javaisotools.sabre.DataReference;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.GregorianCalendar;

public class ISO9660DateDataReference
implements DataReference {
    private Date date = null;

    public ISO9660DateDataReference(Date date) {
        this.date = date;
    }

    public ISO9660DateDataReference(long date) {
        this(new Date(date));
    }

    public ISO9660DateDataReference() {
        this(new Date());
    }

    @Override
    public long getLength() {
        return 17L;
    }

    @Override
    public InputStream createInputStream() throws IOException {
        byte[] buffer = this.date == null ? this.getEmptyDate() : this.getDate();
        return new ByteArrayInputStream(buffer);
    }

    private byte[] getEmptyDate() {
        byte[] buffer = new byte[17];
        for (int i2 = 0; i2 < 16; ++i2) {
            buffer[i2] = 48;
        }
        buffer[16] = 0;
        return buffer;
    }

    private byte[] getDate() {
        byte[] buffer = new byte[17];
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this.date);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int hundredth_sec = cal.get(14) / 10;
        int gmt_offset = cal.get(15) / 900000;
        StringBuffer dateString = new StringBuffer(17);
        dateString.append(this.padIntToString(year, 4));
        dateString.append(this.padIntToString(month, 2));
        dateString.append(this.padIntToString(day, 2));
        dateString.append(this.padIntToString(hour, 2));
        dateString.append(this.padIntToString(minute, 2));
        dateString.append(this.padIntToString(second, 2));
        dateString.append(this.padIntToString(hundredth_sec, 2));
        dateString.append(0);
        buffer = dateString.toString().getBytes();
        buffer[16] = (byte)gmt_offset;
        return buffer;
    }

    private String padIntToString(int value, int length) {
        String intValue = "" + value;
        StringBuffer buf = new StringBuffer(intValue);
        while (buf.length() < length) {
            buf.insert(0, "0");
        }
        return buf.toString();
    }
}

