/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.iso9660.impl;

import com.github.stephenc.javaisotools.iso9660.FilenameDataReference;
import com.github.stephenc.javaisotools.iso9660.ISO9660Directory;
import com.github.stephenc.javaisotools.iso9660.ISO9660File;
import com.github.stephenc.javaisotools.iso9660.ISO9660HierarchyObject;
import com.github.stephenc.javaisotools.iso9660.ISO9660RootDirectory;
import com.github.stephenc.javaisotools.iso9660.LayoutHelper;
import com.github.stephenc.javaisotools.iso9660.NamingConventions;
import com.github.stephenc.javaisotools.iso9660.StandardConfig;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660Factory;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660ShortDateDataReference;
import com.github.stephenc.javaisotools.iso9660.impl.LogicalSectorElement;
import com.github.stephenc.javaisotools.iso9660.sabre.impl.BothWordDataReference;
import com.github.stephenc.javaisotools.rockridge.impl.POSIXFileMode;
import com.github.stephenc.javaisotools.rockridge.impl.RRIPFactory;
import com.github.stephenc.javaisotools.rockridge.impl.RockRidgeLayoutHelper;
import com.github.stephenc.javaisotools.rockridge.impl.RockRidgeNamingConventions;
import com.github.stephenc.javaisotools.sabre.Fixup;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ISO9660RockRidgeFactory
extends ISO9660Factory {
    private RRIPFactory rripFactory;
    private LinkedList unfinishedNMEntries;
    private RockRidgeLayoutHelper helper;
    private ISO9660RootDirectory rripRoot;
    private HashMap originalParentMapper;
    private HashMap parentLocationFixups;
    private HashMap parentLocations;
    private HashMap childLocationFixups;
    private HashMap childLocations;
    private final Map<String, Integer> fileModesMap;

    public ISO9660RockRidgeFactory(StreamHandler streamHandler, StandardConfig config, LayoutHelper helper, ISO9660RootDirectory root, ISO9660RootDirectory isoRoot, HashMap volumeFixups, Map<String, Integer> fileModesMap) {
        super(streamHandler, config, helper, isoRoot, volumeFixups);
        this.rripFactory = new RRIPFactory(streamHandler);
        this.unfinishedNMEntries = new LinkedList();
        this.rripRoot = (ISO9660RootDirectory)root.clone();
        this.helper = new RockRidgeLayoutHelper(streamHandler, isoRoot, this.rripRoot);
        this.originalParentMapper = new HashMap();
        this.fileModesMap = fileModesMap;
    }

    @Override
    public void applyNamingConventions() throws HandlerException {
        super.applyNamingConventions();
        NamingConventions namingConventions = this.helper.getNamingConventions();
        namingConventions.processDirectory(this.rripRoot);
        Iterator<ISO9660Directory> sit = this.rripRoot.unsortedIterator();
        while (sit.hasNext()) {
            ISO9660Directory dir = sit.next();
            namingConventions.processDirectory(dir);
        }
    }

    @Override
    public void relocateDirectories() {
        if (this.rripRoot.deepLevelCount() >= 8) {
            this.parentLocationFixups = new HashMap();
            this.parentLocations = new HashMap();
            this.childLocationFixups = new HashMap();
            this.childLocations = new HashMap();
            this.rripRoot.setMovedDirectoryStore();
            if (RockRidgeNamingConventions.HIDE_MOVED_DIRECTORIES_STORE && !this.rripRoot.getMovedDirectoriesStore().getName().startsWith(".")) {
                this.rripRoot.getMovedDirectoriesStore().setName("." + ISO9660RootDirectory.MOVED_DIRECTORIES_STORE_NAME);
            }
        }
        super.relocateDirectories();
    }

    @Override
    ISO9660Directory relocate(ISO9660Directory dir) {
        ISO9660Directory originalParent = super.relocate(dir);
        this.helper.matchDirectory(dir).relocate();
        if (dir.getRoot() == this.root) {
            this.originalParentMapper.put(originalParent, dir);
        }
        return originalParent;
    }

    @Override
    public void doDRA() throws HandlerException {
        super.doDRA();
        if (this.originalParentMapper.size() > 0) {
            this.doRelocationFixups();
        }
        this.doCA();
    }

    @Override
    void doDir(ISO9660Directory dir, HashMap parentMapper) throws HandlerException {
        Integer location = new Integer(this.helper.getCurrentLocation());
        if (this.originalParentMapper.containsKey(dir)) {
            this.parentLocations.put(this.originalParentMapper.get(dir), location);
        } else if (dir.isMoved()) {
            this.childLocations.put(dir, location);
        }
        super.doDir(dir, parentMapper);
    }

    @Override
    HashMap doFakeDR(ISO9660Directory dir) throws HandlerException {
        long position = this.streamHandler.mark();
        HashMap memory = super.doFakeDR(dir);
        if (RRIPFactory.MKISOFS_COMPATIBILITY) {
            int flags = 25;
            this.rripFactory.doRREntry(flags);
        }
        int fileModes = this.getPOSIXFileModeForObject(dir).getFileMode();
        int fileLinks = 2 + dir.getDirectories().size();
        this.rripFactory.doPXEntry(fileModes, fileLinks, 0, 0, 1L);
        this.childLocationFixups.put(dir, this.rripFactory.doCLEntry());
        int length = this.helper.getDifferenceTo(position);
        length = this.doNM(this.helper.getFilenameDataReference(dir), length);
        return this.finalizeDR(memory, length);
    }

    @Override
    HashMap doDR(ISO9660File file) throws HandlerException {
        long position = this.streamHandler.mark();
        HashMap memory = super.doDR(file);
        if (RRIPFactory.MKISOFS_COMPATIBILITY) {
            int flags = 137;
            this.rripFactory.doRREntry(flags);
        }
        POSIXFileMode fileMode = this.getPOSIXFileModeForObject(file);
        int fileModes = fileMode.getFileMode();
        this.rripFactory.doPXEntry(fileModes, 1, 0, 0, 1L);
        ISO9660ShortDateDataReference date = new ISO9660ShortDateDataReference(file.lastModified());
        this.rripFactory.doTFEntry(2, date);
        int length = this.helper.getDifferenceTo(position);
        length = this.doNM(this.helper.getFilenameDataReference(file), length);
        return this.finalizeDR(memory, length);
    }

    @Override
    HashMap doDR(ISO9660Directory dir) throws HandlerException {
        long position = this.streamHandler.mark();
        HashMap memory = super.doDR(dir);
        if (RRIPFactory.MKISOFS_COMPATIBILITY) {
            int flags = 137;
            if (dir.isMoved()) {
                flags |= 0x40;
            }
            this.rripFactory.doRREntry(flags);
        }
        if (dir.isMoved()) {
            this.rripFactory.doREEntry();
        }
        POSIXFileMode fileMode = this.getPOSIXFileModeForObject(dir);
        int fileModes = fileMode.getFileMode();
        int fileLinks = 2 + dir.getDirectories().size();
        this.rripFactory.doPXEntry(fileModes, fileLinks, 0, 0, 1L);
        ISO9660ShortDateDataReference date = new ISO9660ShortDateDataReference(dir.lastModified());
        this.rripFactory.doTFEntry(2, date);
        int length = this.helper.getDifferenceTo(position);
        length = this.doNM(this.helper.getFilenameDataReference(dir), length);
        return this.finalizeDR(memory, length);
    }

    @Override
    HashMap doDotDR(ISO9660Directory dir) throws HandlerException {
        long position = this.streamHandler.mark();
        HashMap memory = super.doDotDR(dir);
        if (dir == this.root) {
            this.rripFactory.doSPEntry(0);
        }
        if (RRIPFactory.MKISOFS_COMPATIBILITY) {
            int flags = 129;
            this.rripFactory.doRREntry(flags);
        }
        POSIXFileMode fileMode = this.getPOSIXFileModeForObject(dir);
        int fileModes = fileMode.getFileMode();
        int fileLinks = 2 + dir.getDirectories().size();
        this.rripFactory.doPXEntry(fileModes, fileLinks, 0, 0, 1L);
        ISO9660ShortDateDataReference date = new ISO9660ShortDateDataReference(dir.lastModified());
        this.rripFactory.doTFEntry(2, date);
        if (dir == this.root) {
            HashMap ceMemory = this.rripFactory.doCEEntry();
            this.volumeFixups.put("rripERLocationFixup", ceMemory.get("ceLocationFixup"));
            this.volumeFixups.put("rripERLengthFixup", ceMemory.get("ceLengthFixup"));
            Fixup rripEROffsetFixup = (Fixup)ceMemory.get("ceOffsetFixup");
            rripEROffsetFixup.data(new BothWordDataReference(0L));
            rripEROffsetFixup.close();
        }
        return this.finalizeDR(memory, this.helper.getDifferenceTo(position));
    }

    @Override
    HashMap doDotDotDR(ISO9660Directory dir) throws HandlerException {
        long position = this.streamHandler.mark();
        HashMap memory = super.doDotDotDR(dir);
        ISO9660Directory parentDir = dir.getParentDirectory();
        if (RRIPFactory.MKISOFS_COMPATIBILITY) {
            int flags = 129;
            if (dir.isMoved()) {
                flags |= 0x20;
            }
            this.rripFactory.doRREntry(flags);
        }
        if (dir.isMoved()) {
            this.parentLocationFixups.put(dir, this.rripFactory.doPLEntry());
        }
        POSIXFileMode fileMode = this.getPOSIXFileModeForObject(dir);
        int fileModes = fileMode.getFileMode();
        int fileLinks = 2 + parentDir.getDirectories().size();
        this.rripFactory.doPXEntry(fileModes, fileLinks, 0, 0, 1L);
        ISO9660ShortDateDataReference date = new ISO9660ShortDateDataReference(parentDir.lastModified());
        this.rripFactory.doTFEntry(2, date);
        return this.finalizeDR(memory, this.helper.getDifferenceTo(position));
    }

    private int doNM(FilenameDataReference filename, int drLength) throws HandlerException {
        int lengthToAdd = 5;
        int rest = 254 - drLength;
        if ((long)rest >= filename.getLength() + 5L) {
            this.rripFactory.doNMEntry(0, filename);
            lengthToAdd = (int)((long)lengthToAdd + filename.getLength());
        } else {
            int prefixLength = rest - 33;
            String name = filename.getName();
            FilenameDataReference filenameRest = this.helper.getFilenameDataReference(name.substring(0, prefixLength));
            this.rripFactory.doNMEntry(1, filenameRest);
            HashMap ceMemory = this.rripFactory.doCEEntry();
            UnfinishedNMEntry unfinishedNMEntry = new UnfinishedNMEntry();
            unfinishedNMEntry.location = (Fixup)ceMemory.get("ceLocationFixup");
            unfinishedNMEntry.offset = (Fixup)ceMemory.get("ceOffsetFixup");
            unfinishedNMEntry.length = (Fixup)ceMemory.get("ceLengthFixup");
            unfinishedNMEntry.filenameRest = name.substring(prefixLength);
            this.unfinishedNMEntries.add(unfinishedNMEntry);
            lengthToAdd += prefixLength + 28;
        }
        return drLength + lengthToAdd;
    }

    private HashMap finalizeDR(HashMap memory, int length) throws HandlerException {
        if (length <= 250) {
            length = this.doST(length);
        }
        memory.put("drLength", new Integer(length));
        return memory;
    }

    private int doST(int length) throws HandlerException {
        if (!RRIPFactory.MKISOFS_COMPATIBILITY) {
            this.rripFactory.doSTEntry();
            length += 4;
        }
        return length;
    }

    private void doRelocationFixups() throws HandlerException {
        this.doRelocationFixups(this.parentLocationFixups, this.parentLocations);
        this.doRelocationFixups(this.childLocationFixups, this.childLocations);
    }

    private void doRelocationFixups(HashMap fixups, HashMap locations) throws HandlerException {
        for (ISO9660Directory dir : fixups.keySet()) {
            Fixup locationFixup = (Fixup)fixups.get(dir);
            int location = (Integer)locations.get(dir);
            locationFixup.data(new BothWordDataReference(location));
            locationFixup.close();
        }
    }

    private void doCA() throws HandlerException {
        long position = this.streamHandler.mark();
        this.streamHandler.startElement(new LogicalSectorElement("CA"));
        int location = this.helper.getCurrentLocation();
        Fixup rripERLocationFixup = (Fixup)this.volumeFixups.get("rripERLocationFixup");
        rripERLocationFixup.data(new BothWordDataReference(location));
        rripERLocationFixup.close();
        this.rripFactory.doEREntry();
        int erLength = this.doST(this.helper.getDifferenceTo(position));
        Fixup rripERLengthFixup = (Fixup)this.volumeFixups.get("rripERLengthFixup");
        rripERLengthFixup.data(new BothWordDataReference(erLength));
        rripERLengthFixup.close();
        int offset = erLength;
        for (UnfinishedNMEntry unfinishedNMEntry : this.unfinishedNMEntries) {
            String name = unfinishedNMEntry.filenameRest;
            this.rripFactory.doNMEntry(0, this.helper.getFilenameDataReference(name));
            unfinishedNMEntry.location.data(new BothWordDataReference(location));
            unfinishedNMEntry.location.close();
            unfinishedNMEntry.offset.data(new BothWordDataReference(offset));
            unfinishedNMEntry.offset.close();
            int ceLength = this.doST(name.length() + 5);
            unfinishedNMEntry.length.data(new BothWordDataReference(ceLength));
            unfinishedNMEntry.length.close();
            offset += ceLength;
        }
        this.streamHandler.endElement();
    }

    private POSIXFileMode getPOSIXFileModeForObject(ISO9660HierarchyObject ho) {
        POSIXFileMode ret = new POSIXFileMode();
        for (String pattern : this.fileModesMap.keySet()) {
            Pattern p2 = Pattern.compile(pattern, 2);
            Matcher m2 = p2.matcher(ho.getName());
            if (!m2.matches()) continue;
            POSIXFileMode mode = new POSIXFileMode();
            mode.setDefault(ho instanceof ISO9660Directory);
            mode.setPermission(this.fileModesMap.get(pattern));
            return mode;
        }
        ret.setDefault(ho instanceof ISO9660Directory);
        return ret;
    }

    class UnfinishedNMEntry {
        Fixup location;
        Fixup offset;
        Fixup length;
        String filenameRest;

        UnfinishedNMEntry() {
        }
    }
}

