/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.joliet.impl;

import com.github.stephenc.javaisotools.iso9660.ISO9660RootDirectory;
import com.github.stephenc.javaisotools.iso9660.LayoutHelper;
import com.github.stephenc.javaisotools.iso9660.StandardHandler;
import com.github.stephenc.javaisotools.iso9660.impl.FileElement;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660Constants;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660Element;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660Factory;
import com.github.stephenc.javaisotools.iso9660.impl.LogicalSectorElement;
import com.github.stephenc.javaisotools.iso9660.sabre.impl.BothWordDataReference;
import com.github.stephenc.javaisotools.iso9660.volumedescriptors.SupplementaryVolumeDescriptor;
import com.github.stephenc.javaisotools.joliet.impl.JolietConfig;
import com.github.stephenc.javaisotools.joliet.impl.JolietLayoutHelper;
import com.github.stephenc.javaisotools.sabre.Element;
import com.github.stephenc.javaisotools.sabre.Fixup;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;
import com.github.stephenc.javaisotools.sabre.impl.ByteDataReference;
import java.util.HashMap;

public class JolietHandler
extends StandardHandler {
    private JolietConfig config;
    private LayoutHelper helper;
    private HashMap volumeFixups;
    private ISO9660Factory factory;

    public JolietHandler(StreamHandler streamHandler, ISO9660RootDirectory root, JolietConfig config) throws HandlerException {
        super(streamHandler, root, config);
        this.config = config;
        this.volumeFixups = new HashMap();
        this.checkMetadataFiles();
        ISO9660RootDirectory jolietRoot = (ISO9660RootDirectory)root.clone();
        this.helper = new JolietLayoutHelper(this, jolietRoot, config.getMaxCharsInFilename(), config.getFailOnTruncation());
        this.factory = new ISO9660Factory(this, config, this.helper, jolietRoot, this.volumeFixups);
        this.factory.applyNamingConventions();
    }

    @Override
    public void startElement(Element element) throws HandlerException {
        if (element instanceof ISO9660Element) {
            String id = (String)element.getId();
            this.process(id);
        } else if (element instanceof FileElement) {
            FileElement fileElement = (FileElement)element;
            this.factory.doFileFixup(fileElement.getFile());
        }
        super.startElement(element);
    }

    private void process(String id) throws HandlerException {
        if (id.equals("VDS")) {
            this.doSVD();
        } else if (id.equals("PTA")) {
            this.factory.doPT(ISO9660Constants.TYPE_L_PT);
            this.factory.doPT(ISO9660Constants.TYPE_M_PT);
        } else if (id.equals("DRA")) {
            this.factory.doDRA();
        }
    }

    private void doSVD() throws HandlerException {
        super.startElement(new LogicalSectorElement("SVD"));
        SupplementaryVolumeDescriptor svd = new SupplementaryVolumeDescriptor(this, this.helper);
        svd.setMetadata(this.config);
        this.volumeFixups.putAll(svd.doSVD());
        Fixup volumeFlags = (Fixup)this.volumeFixups.get("volumeFlagsFixup");
        volumeFlags.data(new ByteDataReference(0L));
        volumeFlags.close();
        this.volumeFixups.remove("volumeFlagsFixup");
        Fixup escapeSequences = (Fixup)this.volumeFixups.get("escapeSequencesFixup");
        escapeSequences.data(this.config.getUCS2LevelEscapeSequence());
        escapeSequences.close();
        this.volumeFixups.remove("escapeSequencesFixup");
        super.endElement();
    }

    @Override
    public void endDocument() throws HandlerException {
        Fixup volumeSpaceSizeFixup = (Fixup)this.volumeFixups.get("volumeSpaceSizeFixup");
        volumeSpaceSizeFixup.data(new BothWordDataReference(this.helper.getCurrentLocation()));
        volumeSpaceSizeFixup.close();
        this.volumeFixups.remove("volumeSpaceSizeFixup");
        super.endDocument();
    }
}

