/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.rockridge.impl;

import com.github.stephenc.javaisotools.iso9660.FilenameDataReference;
import com.github.stephenc.javaisotools.iso9660.ISO9660Directory;
import com.github.stephenc.javaisotools.iso9660.ISO9660File;
import com.github.stephenc.javaisotools.iso9660.ISO9660RootDirectory;
import com.github.stephenc.javaisotools.iso9660.LayoutHelper;
import com.github.stephenc.javaisotools.rockridge.impl.RockRidgeFilenameDataReference;
import com.github.stephenc.javaisotools.rockridge.impl.RockRidgeNamingConventions;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;
import java.util.HashMap;
import java.util.Iterator;

public class RockRidgeLayoutHelper
extends LayoutHelper {
    private ISO9660RootDirectory rripRoot;
    private HashMap directoryMapper;
    private HashMap fileMapper;

    public RockRidgeLayoutHelper(StreamHandler streamHandler, ISO9660RootDirectory isoRoot, ISO9660RootDirectory rripRoot) {
        super(streamHandler, isoRoot, new RockRidgeNamingConventions());
        this.rripRoot = rripRoot;
        this.setup(isoRoot);
    }

    private void setup(ISO9660RootDirectory isoRoot) {
        int dirCount = isoRoot.deepDirCount() + 1;
        this.directoryMapper = new HashMap(dirCount);
        int fileCount = isoRoot.deepFileCount() + 1;
        this.fileMapper = new HashMap(fileCount);
        Iterator<ISO9660File> isoFit = isoRoot.getFiles().iterator();
        Iterator<ISO9660File> rripFit = this.rripRoot.getFiles().iterator();
        while (isoFit.hasNext()) {
            ISO9660File isoFile = isoFit.next();
            ISO9660File rripFile = rripFit.next();
            this.fileMapper.put(isoFile, rripFile);
        }
        Iterator<ISO9660Directory> isoIt = isoRoot.unsortedIterator();
        Iterator<ISO9660Directory> rripIt = this.rripRoot.unsortedIterator();
        while (isoIt.hasNext()) {
            ISO9660Directory isoDir = isoIt.next();
            ISO9660Directory rripDir = rripIt.next();
            this.directoryMapper.put(isoDir.getID(), rripDir);
            isoFit = isoDir.getFiles().iterator();
            rripFit = rripDir.getFiles().iterator();
            while (isoFit.hasNext()) {
                ISO9660File isoFile = isoFit.next();
                ISO9660File rripFile = rripFit.next();
                this.fileMapper.put(isoFile.getID(), rripFile);
            }
        }
    }

    @Override
    public FilenameDataReference getFilenameDataReference(ISO9660Directory dir) throws HandlerException {
        return new RockRidgeFilenameDataReference(this.matchDirectory(dir));
    }

    @Override
    public FilenameDataReference getFilenameDataReference(ISO9660File file) throws HandlerException {
        return new RockRidgeFilenameDataReference(this.matchFile(file));
    }

    public FilenameDataReference getFilenameDataReference(String name) throws HandlerException {
        return new RockRidgeFilenameDataReference(name);
    }

    public ISO9660Directory matchDirectory(ISO9660Directory dir) {
        if (dir == dir.getRoot()) {
            return this.rripRoot;
        }
        if (dir == dir.getRoot().getMovedDirectoriesStore()) {
            return this.rripRoot.getMovedDirectoriesStore();
        }
        ISO9660Directory rripDir = (ISO9660Directory)this.directoryMapper.get(dir.getID());
        if (rripDir != null) {
            return rripDir;
        }
        throw new RuntimeException("No matching directory found for " + dir.getISOPath());
    }

    public ISO9660File matchFile(ISO9660File file) {
        ISO9660File rripFile = (ISO9660File)this.fileMapper.get(file.getID());
        if (rripFile != null) {
            return rripFile;
        }
        throw new RuntimeException("No matching file found for " + file.getISOPath());
    }

    @Override
    public byte[] pad(String string, int targetByteLength) throws HandlerException {
        return null;
    }
}

