/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.rockridge.impl;

import com.github.stephenc.javaisotools.rockridge.impl.SystemUseEntryElement;
import com.github.stephenc.javaisotools.sabre.ContentHandler;
import com.github.stephenc.javaisotools.sabre.DataReference;
import com.github.stephenc.javaisotools.sabre.Element;
import com.github.stephenc.javaisotools.sabre.Fixup;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StructureHandler;
import com.github.stephenc.javaisotools.sabre.impl.ByteArrayDataReference;
import com.github.stephenc.javaisotools.sabre.impl.ByteDataReference;
import com.github.stephenc.javaisotools.sabre.impl.ChainingStreamHandler;
import java.util.Stack;

public class SystemUseEntryHandler
extends ChainingStreamHandler {
    private Stack elements = new Stack();
    private int length = 0;
    private Fixup lengthFixup;

    public SystemUseEntryHandler(StructureHandler chainingStructureHandler, ContentHandler chainingContentHandler) {
        super(chainingStructureHandler, chainingContentHandler);
    }

    @Override
    public void startElement(Element element) throws HandlerException {
        this.elements.push(element);
        if (element instanceof SystemUseEntryElement) {
            SystemUseEntryElement sue = (SystemUseEntryElement)element;
            this.length = 0;
            this.data(new ByteArrayDataReference(sue.getSignatureWord()));
            this.lengthFixup = this.fixup(new ByteDataReference(0L));
            this.data(new ByteDataReference(sue.getVersion()));
        }
        super.startElement(element);
    }

    @Override
    public void data(DataReference reference) throws HandlerException {
        this.length = (int)((long)this.length + reference.getLength());
        super.data(reference);
    }

    @Override
    public Fixup fixup(DataReference reference) throws HandlerException {
        this.length = (int)((long)this.length + reference.getLength());
        return super.fixup(reference);
    }

    @Override
    public void endElement() throws HandlerException {
        Element element = (Element)this.elements.pop();
        if (element instanceof SystemUseEntryElement) {
            if (this.length > 255) {
                throw new RuntimeException("Invalid System Use Entry length: " + this.length);
            }
            this.lengthFixup.data(new ByteDataReference(this.length));
            this.lengthFixup.close();
        }
        super.endElement();
    }
}

