/*
 * Decompiled with CFR 0.152.
 */
package net.didion.loopy.iso9660;

import java.io.IOException;
import java.io.InputStream;
import net.didion.loopy.iso9660.ISO9660FileEntry;
import net.didion.loopy.iso9660.ISO9660FileSystem;

class EntryInputStream
extends InputStream {
    private ISO9660FileEntry entry;
    private ISO9660FileSystem fileSystem;
    private int pos;
    private int rem;

    EntryInputStream(ISO9660FileEntry entry, ISO9660FileSystem fileSystem) {
        this.fileSystem = fileSystem;
        this.entry = entry;
        this.pos = 0;
        this.rem = entry.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b2, int off, int len) throws IOException {
        int read;
        this.ensureOpen();
        if (this.rem <= 0) {
            return -1;
        }
        if (len <= 0) {
            return 0;
        }
        int toRead = len;
        if (toRead > this.rem) {
            toRead = this.rem;
        }
        ISO9660FileSystem iSO9660FileSystem = this.fileSystem;
        synchronized (iSO9660FileSystem) {
            if (this.fileSystem.isClosed()) {
                throw new IOException("ISO file closed.");
            }
            read = this.fileSystem.readBytes(this.entry, this.pos, b2, off, toRead);
        }
        if (read > 0) {
            this.pos += len;
            this.rem -= len;
        }
        return read;
    }

    public int read() throws IOException {
        this.ensureOpen();
        byte[] b2 = new byte[1];
        if (this.read(b2, 0, 1) == 1) {
            return b2[0] & 0xFF;
        }
        return -1;
    }

    public long skip(long n2) {
        this.ensureOpen();
        int len = n2 > (long)this.rem ? this.rem : (int)n2;
        this.pos += len;
        this.rem -= len;
        if (this.rem <= 0) {
            this.close();
        }
        return len;
    }

    public int available() {
        return Math.max(this.rem, 0);
    }

    public int size() {
        this.ensureOpen();
        return this.entry.getSize();
    }

    public void close() {
        this.rem = 0;
        this.entry = null;
        this.fileSystem = null;
    }

    private void ensureOpen() {
        if (null == this.entry) {
            throw new IllegalStateException("stream has been closed");
        }
    }
}

