/*
 * Decompiled with CFR 0.152.
 */
package net.didion.loopy.iso9660;

import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.TimeZone;
import net.didion.loopy.util.BigEndian;
import net.didion.loopy.util.LittleEndian;

public final class Util {
    public static int getUInt8(byte[] block, int pos) {
        return LittleEndian.getUInt8(block, pos - 1);
    }

    public static int getInt8(byte[] block, int pos) {
        return LittleEndian.getInt8(block, pos - 1);
    }

    public static int getUInt16LE(byte[] block, int pos) {
        return LittleEndian.getUInt16(block, pos - 1);
    }

    public static int getUInt16BE(byte[] block, int pos) {
        return BigEndian.getUInt16(block, pos - 1);
    }

    public static int getUInt16Both(byte[] block, int pos) {
        return LittleEndian.getUInt16(block, pos - 1);
    }

    public static long getUInt32LE(byte[] block, int pos) {
        return LittleEndian.getUInt32(block, pos - 1);
    }

    public static long getUInt32BE(byte[] block, int pos) {
        return BigEndian.getUInt32(block, pos - 1);
    }

    public static long getUInt32Both(byte[] block, int pos) {
        return LittleEndian.getUInt32(block, pos - 1);
    }

    public static String getAChars(byte[] block, int pos, int length) {
        return new String(block, pos - 1, length).trim();
    }

    public static String getDChars(byte[] block, int pos, int length) {
        return new String(block, pos - 1, length).trim();
    }

    public static String getAChars(byte[] block, int pos, int length, String encoding) {
        try {
            return new String(block, pos - 1, length, encoding).trim();
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getDChars(byte[] block, int pos, int length, String encoding) {
        try {
            return new String(block, pos - 1, length, encoding).trim();
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static long getStringDate(byte[] block, int pos) {
        int i2 = pos - 1;
        Calendar cal = Calendar.getInstance();
        cal.set(1, Util.toInt(block, i2, 4));
        cal.set(2, Util.toInt(block, i2 += 4, 2) - 1);
        cal.set(5, Util.toInt(block, i2 += 2, 2));
        cal.set(11, Util.toInt(block, i2 += 2, 2));
        cal.set(12, Util.toInt(block, i2 += 2, 2));
        cal.set(13, Util.toInt(block, i2 += 2, 2));
        cal.set(14, Util.toInt(block, i2 += 2, 2) * 10);
        cal.setTimeZone(TimeZone.getTimeZone(Util.getGMTpos(block[i2 + 2])));
        return cal.getTimeInMillis();
    }

    private static int toInt(byte[] block, int pos, int len) {
        try {
            return Integer.parseInt(new String(block, pos, len));
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static long getDateTime(byte[] sector, int pos) {
        int i2 = pos - 1;
        Calendar cal = Calendar.getInstance();
        cal.set(1, 1900 + sector[i2]);
        cal.set(2, sector[i2 + 1] - 1);
        cal.set(5, sector[i2 + 2]);
        cal.set(11, sector[i2 + 3]);
        cal.set(12, sector[i2 + 4]);
        cal.set(13, sector[i2 + 5]);
        cal.set(14, 0);
        cal.setTimeZone(TimeZone.getTimeZone(Util.getGMTpos(sector[i2 + 6])));
        return cal.getTimeInMillis();
    }

    private static String getGMTpos(byte b2) {
        if (0 == b2) {
            return "GMT";
        }
        StringBuffer buf = new StringBuffer("GMT");
        buf.append(b2 < 0 ? (char)'-' : '+');
        int posMinutes = Math.abs(b2) * 15;
        int hours = posMinutes / 60;
        int minutes = posMinutes % 60;
        buf.append(hours).append(':').append(0 == minutes ? "00" : String.valueOf(minutes));
        return buf.toString();
    }

    private Util() {
    }
}

