/*
 * Decompiled with CFR 0.152.
 */
package net.didion.loopy.vfs.provider.iso;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import net.didion.loopy.iso9660.ISO9660FileEntry;
import net.didion.loopy.iso9660.ISO9660FileSystem;
import net.didion.loopy.vfs.provider.iso.IsoFileObject;
import net.didion.loopy.vfs.provider.iso.IsoFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.Selectors;
import org.apache.commons.vfs.VfsLog;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.UriParser;

public class IsoFileSystem
extends AbstractFileSystem {
    private static final Log log = LogFactory.getLog(IsoFileSystem.class);
    private ISO9660FileSystem fileSystem;

    public IsoFileSystem(FileName rootName, FileObject parentLayer, FileSystemOptions fileSystemOptions) throws FileSystemException {
        super(rootName, parentLayer, fileSystemOptions);
    }

    public void init() throws FileSystemException {
        super.init();
        File file = this.getParentLayer().getFileSystem().replicateFile(this.getParentLayer(), Selectors.SELECT_SELF);
        try {
            this.fileSystem = new ISO9660FileSystem(file, true);
        }
        catch (IOException ex) {
            throw new FileSystemException("vfs.provider.iso/open-iso-file.error", file, (Throwable)ex);
        }
        ArrayList<IsoFileObject> strongRef = new ArrayList<IsoFileObject>(100);
        Enumeration entries = this.fileSystem.getEntries();
        boolean skipRoot = false;
        while (entries.hasMoreElements()) {
            IsoFileObject fileObj;
            ISO9660FileEntry entry = (ISO9660FileEntry)entries.nextElement();
            String name = entry.getPath();
            if ("".equals(name)) {
                if (skipRoot) continue;
                skipRoot = true;
            }
            FileName filename = this.getFileSystemManager().resolveName(this.getRootName(), UriParser.encode(name));
            if (entry.isDirectory() && this.getFileFromCache(filename) != null) {
                fileObj = (IsoFileObject)this.getFileFromCache(filename);
                fileObj.setIsoEntry(entry);
                continue;
            }
            fileObj = new IsoFileObject(filename, entry, this);
            this.putFileToCache(fileObj);
            strongRef.add(fileObj);
            fileObj.holdObject(strongRef);
            for (FileName parentName = filename.getParent(); parentName != null; parentName = parentName.getParent()) {
                IsoFileObject parent = (IsoFileObject)this.getFileFromCache(parentName);
                if (parent == null) {
                    parent = new IsoFileObject(parentName, this);
                    this.putFileToCache(parent);
                    strongRef.add(parent);
                    parent.holdObject(strongRef);
                }
                parent.attachChild(fileObj.getName());
                fileObj = parent;
            }
        }
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(IsoFileProvider.capabilities);
    }

    protected FileObject createFile(FileName name) throws Exception {
        return new IsoFileObject(name, this);
    }

    protected void doCloseCommunicationLink() {
        if (null != this.fileSystem && !this.fileSystem.isClosed()) {
            try {
                this.fileSystem.close();
            }
            catch (IOException ex) {
                VfsLog.warn(this.getLogger(), log, "vfs.provider.iso/close-iso-file.error :" + this.fileSystem, ex);
            }
        }
    }

    public void close() {
        super.close();
        this.fileSystem = null;
    }

    InputStream getInputStream(ISO9660FileEntry entry) {
        return this.fileSystem.getInputStream(entry);
    }
}

