/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class UserAuthenticationData {
    public static final Type USERNAME = new Type("username");
    public static final Type PASSWORD = new Type("password");
    public static final Type DOMAIN = new Type("domain");
    private Map authenticationData = new TreeMap();

    public void setData(Type type, char[] data) {
        this.authenticationData.put(type, data);
    }

    public char[] getData(Type type) {
        return (char[])this.authenticationData.get(type);
    }

    public void cleanup() {
        Iterator iterAuthenticationData = this.authenticationData.values().iterator();
        while (iterAuthenticationData.hasNext()) {
            char[] data = (char[])iterAuthenticationData.next();
            if (data == null || data.length < 0) continue;
            for (int i2 = 0; i2 < data.length; ++i2) {
                data[i2] = '\u0000';
            }
        }
        this.authenticationData.clear();
    }

    public static class Type
    implements Comparable {
        private final String type;

        public Type(String type) {
            this.type = type;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Type type1 = (Type)o2;
            return !(this.type != null ? !this.type.equals(type1.type) : type1.type != null);
        }

        public int compareTo(Object o2) {
            Type t2 = (Type)o2;
            return this.type.compareTo(t2.type);
        }
    }
}

