/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.bzip2;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.vfs.provider.bzip2.BZip2Constants;
import org.apache.commons.vfs.provider.bzip2.CRC;

class CBZip2OutputStream
extends OutputStream
implements BZip2Constants {
    private static final int LOWER_BYTE_MASK = 255;
    private static final int UPPER_BYTE_MASK = -256;
    private static final int SETMASK = 0x200000;
    private static final int CLEARMASK = -2097153;
    private static final int GREATER_ICOST = 15;
    private static final int LESSER_ICOST = 0;
    private static final int SMALL_THRESH = 20;
    private static final int DEPTH_THRESH = 10;
    private static final int QSORT_STACK_SIZE = 1000;
    private CRC m_crc = new CRC();
    private boolean[] m_inUse = new boolean[256];
    private char[] m_seqToUnseq = new char[256];
    private char[] m_unseqToSeq = new char[256];
    private char[] m_selector = new char[18002];
    private char[] m_selectorMtf = new char[18002];
    private int[] m_mtfFreq = new int[258];
    private int m_currentChar = -1;
    private int m_runLength;
    private boolean m_closed;
    private int[] m_incs = new int[]{1, 4, 13, 40, 121, 364, 1093, 3280, 9841, 29524, 88573, 265720, 797161, 2391484};
    private boolean m_blockRandomised;
    private int m_blockSize100k;
    private int m_bsBuff;
    private int m_bsLive;
    private int m_last;
    private int m_origPtr;
    private int m_allowableBlockSize;
    private char[] m_block;
    private int m_blockCRC;
    private int m_combinedCRC;
    private OutputStream m_bsStream;
    private boolean m_firstAttempt;
    private int[] m_ftab;
    private int m_nInUse;
    private int m_nMTF;
    private int[] m_quadrant;
    private short[] m_szptr;
    private int m_workDone;
    private int m_workFactor;
    private int m_workLimit;
    private int[] m_zptr;

    CBZip2OutputStream(OutputStream output) throws IOException {
        this(output, 9);
    }

    CBZip2OutputStream(OutputStream output, int blockSize) throws IOException {
        this.bsSetStream(output);
        this.m_workFactor = 50;
        int outBlockSize = blockSize;
        if (outBlockSize > 9) {
            outBlockSize = 9;
        }
        if (outBlockSize < 1) {
            outBlockSize = 1;
        }
        this.m_blockSize100k = outBlockSize;
        this.allocateCompressStructures();
        this.initialize();
        this.initBlock();
    }

    private static void hbMakeCodeLengths(char[] len, int[] freq, int alphaSize, int maxLen) {
        int i2;
        int[] heap = new int[260];
        int[] weights = new int[516];
        int[] parent = new int[516];
        for (i2 = 0; i2 < alphaSize; ++i2) {
            weights[i2 + 1] = (freq[i2] == 0 ? 1 : freq[i2]) << 8;
        }
        block1: while (true) {
            int j2;
            int zz;
            int nNodes = alphaSize;
            int nHeap = 0;
            heap[0] = 0;
            weights[0] = 0;
            parent[0] = -2;
            for (i2 = 1; i2 <= alphaSize; ++i2) {
                parent[i2] = -1;
                heap[++nHeap] = i2;
                zz = nHeap;
                int tmp = heap[zz];
                while (weights[tmp] < weights[heap[zz >> 1]]) {
                    heap[zz] = heap[zz >> 1];
                    zz >>= 1;
                }
                heap[zz] = tmp;
            }
            if (nHeap >= 260) {
                CBZip2OutputStream.panic();
            }
            while (nHeap > 1) {
                int weight;
                int n1 = heap[1];
                heap[1] = heap[nHeap];
                --nHeap;
                zz = 0;
                int yy = 0;
                int tmp = 0;
                zz = 1;
                tmp = heap[zz];
                while ((yy = zz << 1) <= nHeap) {
                    if (yy < nHeap && weights[heap[yy + 1]] < weights[heap[yy]]) {
                        ++yy;
                    }
                    if (weights[tmp] < weights[heap[yy]]) break;
                    heap[zz] = heap[yy];
                    zz = yy;
                }
                heap[zz] = tmp;
                int n2 = heap[1];
                heap[1] = heap[nHeap];
                --nHeap;
                zz = 0;
                yy = 0;
                tmp = 0;
                zz = 1;
                tmp = heap[zz];
                while ((yy = zz << 1) <= nHeap) {
                    if (yy < nHeap && weights[heap[yy + 1]] < weights[heap[yy]]) {
                        ++yy;
                    }
                    if (weights[tmp] < weights[heap[yy]]) break;
                    heap[zz] = heap[yy];
                    zz = yy;
                }
                heap[zz] = tmp;
                parent[n1] = ++nNodes;
                parent[n2] = nNodes;
                int v1 = weights[n1];
                int v2 = weights[n2];
                weights[nNodes] = weight = CBZip2OutputStream.calculateWeight(v1, v2);
                parent[nNodes] = -1;
                heap[++nHeap] = nNodes;
                int zz2 = 0;
                int tmp2 = 0;
                zz2 = nHeap;
                tmp2 = heap[zz2];
                while (weights[tmp2] < weights[heap[zz2 >> 1]]) {
                    heap[zz2] = heap[zz2 >> 1];
                    zz2 >>= 1;
                }
                heap[zz2] = tmp2;
            }
            if (nNodes >= 516) {
                CBZip2OutputStream.panic();
            }
            boolean tooLong = false;
            for (i2 = 1; i2 <= alphaSize; ++i2) {
                j2 = 0;
                int k2 = i2;
                while (parent[k2] >= 0) {
                    k2 = parent[k2];
                    ++j2;
                }
                len[i2 - 1] = (char)j2;
                if (j2 <= maxLen) continue;
                tooLong = true;
            }
            if (!tooLong) break;
            i2 = 1;
            while (true) {
                if (i2 >= alphaSize) continue block1;
                j2 = weights[i2] >> 8;
                j2 = 1 + j2 / 2;
                weights[i2] = j2 << 8;
                ++i2;
            }
            break;
        }
    }

    private static int calculateWeight(int v1, int v2) {
        int upper = (v1 & 0xFFFFFF00) + (v2 & 0xFFFFFF00);
        int v1Lower = v1 & 0xFF;
        int v2Lower = v2 & 0xFF;
        int nnnn = v1Lower > v2Lower ? v1Lower : v2Lower;
        return upper | 1 + nnnn;
    }

    private static void panic() {
        System.out.println("panic");
    }

    public void close() throws IOException {
        if (this.m_closed) {
            return;
        }
        if (this.m_runLength > 0) {
            this.writeRun();
        }
        this.m_currentChar = -1;
        this.endBlock();
        this.endCompression();
        this.m_closed = true;
        super.close();
        this.m_bsStream.close();
    }

    public void finalize() throws Throwable {
        this.close();
    }

    public void flush() throws IOException {
        super.flush();
        this.m_bsStream.flush();
    }

    public void write(int bv) throws IOException {
        int b2 = (256 + bv) % 256;
        if (this.m_currentChar != -1) {
            if (this.m_currentChar == b2) {
                ++this.m_runLength;
                if (this.m_runLength > 254) {
                    this.writeRun();
                    this.m_currentChar = -1;
                    this.m_runLength = 0;
                }
            } else {
                this.writeRun();
                this.m_runLength = 1;
                this.m_currentChar = b2;
            }
        } else {
            this.m_currentChar = b2;
            ++this.m_runLength;
        }
    }

    private void allocateCompressStructures() {
        int n2 = 100000 * this.m_blockSize100k;
        this.m_block = new char[n2 + 1 + 20];
        this.m_quadrant = new int[n2 + 20];
        this.m_zptr = new int[n2];
        this.m_ftab = new int[65537];
        if (this.m_block == null || this.m_quadrant == null || this.m_zptr == null || this.m_ftab == null) {
            // empty if block
        }
        this.m_szptr = new short[2 * n2];
    }

    private void bsFinishedWithStream() throws IOException {
        while (this.m_bsLive > 0) {
            int ch = this.m_bsBuff >> 24;
            this.m_bsStream.write(ch);
            this.m_bsBuff <<= 8;
            this.m_bsLive -= 8;
        }
    }

    private void bsPutIntVS(int numBits, int c2) throws IOException {
        this.bsW(numBits, c2);
    }

    private void bsPutUChar(int c2) throws IOException {
        this.bsW(8, c2);
    }

    private void bsPutint(int u2) throws IOException {
        this.bsW(8, u2 >> 24 & 0xFF);
        this.bsW(8, u2 >> 16 & 0xFF);
        this.bsW(8, u2 >> 8 & 0xFF);
        this.bsW(8, u2 & 0xFF);
    }

    private void bsSetStream(OutputStream f2) {
        this.m_bsStream = f2;
        this.m_bsLive = 0;
        this.m_bsBuff = 0;
    }

    private void bsW(int n2, int v2) throws IOException {
        while (this.m_bsLive >= 8) {
            int ch = this.m_bsBuff >> 24;
            this.m_bsStream.write(ch);
            this.m_bsBuff <<= 8;
            this.m_bsLive -= 8;
        }
        this.m_bsBuff |= v2 << 32 - this.m_bsLive - n2;
        this.m_bsLive += n2;
    }

    private void doReversibleTransformation() {
        this.m_workLimit = this.m_workFactor * this.m_last;
        this.m_workDone = 0;
        this.m_blockRandomised = false;
        this.m_firstAttempt = true;
        this.mainSort();
        if (this.m_workDone > this.m_workLimit && this.m_firstAttempt) {
            this.randomiseBlock();
            this.m_workLimit = 0;
            this.m_workDone = 0;
            this.m_blockRandomised = true;
            this.m_firstAttempt = false;
            this.mainSort();
        }
        this.m_origPtr = -1;
        for (int i2 = 0; i2 <= this.m_last; ++i2) {
            if (this.m_zptr[i2] != 0) continue;
            this.m_origPtr = i2;
            break;
        }
        if (this.m_origPtr == -1) {
            CBZip2OutputStream.panic();
        }
    }

    private void endBlock() throws IOException {
        this.m_blockCRC = this.m_crc.getFinalCRC();
        this.m_combinedCRC = this.m_combinedCRC << 1 | this.m_combinedCRC >>> 31;
        this.m_combinedCRC ^= this.m_blockCRC;
        this.doReversibleTransformation();
        this.bsPutUChar(49);
        this.bsPutUChar(65);
        this.bsPutUChar(89);
        this.bsPutUChar(38);
        this.bsPutUChar(83);
        this.bsPutUChar(89);
        this.bsPutint(this.m_blockCRC);
        if (this.m_blockRandomised) {
            this.bsW(1, 1);
        } else {
            this.bsW(1, 0);
        }
        this.moveToFrontCodeAndSend();
    }

    private void endCompression() throws IOException {
        this.bsPutUChar(23);
        this.bsPutUChar(114);
        this.bsPutUChar(69);
        this.bsPutUChar(56);
        this.bsPutUChar(80);
        this.bsPutUChar(144);
        this.bsPutint(this.m_combinedCRC);
        this.bsFinishedWithStream();
    }

    private boolean fullGtU(int i1, int i2) {
        char c1 = this.m_block[i1 + 1];
        char c2 = this.m_block[i2 + 1];
        if (c1 != c2) {
            return c1 > c2;
        }
        if ((c1 = this.m_block[++i1 + 1]) != (c2 = this.m_block[++i2 + 1])) {
            return c1 > c2;
        }
        if ((c1 = this.m_block[++i1 + 1]) != (c2 = this.m_block[++i2 + 1])) {
            return c1 > c2;
        }
        if ((c1 = this.m_block[++i1 + 1]) != (c2 = this.m_block[++i2 + 1])) {
            return c1 > c2;
        }
        if ((c1 = this.m_block[++i1 + 1]) != (c2 = this.m_block[++i2 + 1])) {
            return c1 > c2;
        }
        if ((c1 = this.m_block[++i1 + 1]) != (c2 = this.m_block[++i2 + 1])) {
            return c1 > c2;
        }
        ++i1;
        ++i2;
        int k2 = this.m_last + 1;
        do {
            if ((c1 = this.m_block[i1 + 1]) != (c2 = this.m_block[i2 + 1])) {
                return c1 > c2;
            }
            int s1 = this.m_quadrant[i1];
            int s2 = this.m_quadrant[i2];
            if (s1 != s2) {
                return s1 > s2;
            }
            if ((c1 = this.m_block[++i1 + 1]) != (c2 = this.m_block[++i2 + 1])) {
                return c1 > c2;
            }
            s1 = this.m_quadrant[i1];
            s2 = this.m_quadrant[i2];
            if (s1 != s2) {
                return s1 > s2;
            }
            if ((c1 = this.m_block[++i1 + 1]) != (c2 = this.m_block[++i2 + 1])) {
                return c1 > c2;
            }
            s1 = this.m_quadrant[i1];
            s2 = this.m_quadrant[i2];
            if (s1 != s2) {
                return s1 > s2;
            }
            if ((c1 = this.m_block[++i1 + 1]) != (c2 = this.m_block[++i2 + 1])) {
                return c1 > c2;
            }
            s1 = this.m_quadrant[i1];
            s2 = this.m_quadrant[i2];
            if (s1 != s2) {
                return s1 > s2;
            }
            ++i2;
            if (++i1 > this.m_last) {
                i1 -= this.m_last;
                --i1;
            }
            if (i2 > this.m_last) {
                i2 -= this.m_last;
                --i2;
            }
            ++this.m_workDone;
        } while ((k2 -= 4) >= 0);
        return false;
    }

    private void generateMTFValues() {
        int i2;
        char[] yy = new char[256];
        this.makeMaps();
        int EOB = this.m_nInUse + 1;
        for (i2 = 0; i2 <= EOB; ++i2) {
            this.m_mtfFreq[i2] = 0;
        }
        int wr = 0;
        int zPend = 0;
        for (i2 = 0; i2 < this.m_nInUse; ++i2) {
            yy[i2] = (char)i2;
        }
        for (i2 = 0; i2 <= this.m_last; ++i2) {
            char ll_i = this.m_unseqToSeq[this.m_block[this.m_zptr[i2]]];
            int j2 = 0;
            char tmp = yy[j2];
            while (ll_i != tmp) {
                char tmp2 = tmp;
                tmp = yy[++j2];
                yy[j2] = tmp2;
            }
            yy[0] = tmp;
            if (j2 == 0) {
                ++zPend;
                continue;
            }
            if (zPend > 0) {
                --zPend;
                while (true) {
                    switch (zPend % 2) {
                        case 0: {
                            this.m_szptr[wr] = 0;
                            ++wr;
                            this.m_mtfFreq[0] = this.m_mtfFreq[0] + 1;
                            break;
                        }
                        case 1: {
                            this.m_szptr[wr] = 1;
                            ++wr;
                            this.m_mtfFreq[1] = this.m_mtfFreq[1] + 1;
                        }
                    }
                    if (zPend < 2) break;
                    zPend = (zPend - 2) / 2;
                }
                zPend = 0;
            }
            this.m_szptr[wr] = (short)(j2 + 1);
            ++wr;
            int n2 = j2 + 1;
            this.m_mtfFreq[n2] = this.m_mtfFreq[n2] + 1;
        }
        if (zPend > 0) {
            --zPend;
            while (true) {
                switch (zPend % 2) {
                    case 0: {
                        this.m_szptr[wr] = 0;
                        ++wr;
                        this.m_mtfFreq[0] = this.m_mtfFreq[0] + 1;
                        break;
                    }
                    case 1: {
                        this.m_szptr[wr] = 1;
                        ++wr;
                        this.m_mtfFreq[1] = this.m_mtfFreq[1] + 1;
                    }
                }
                if (zPend < 2) break;
                zPend = (zPend - 2) / 2;
            }
        }
        this.m_szptr[wr] = (short)EOB;
        int n3 = EOB;
        this.m_mtfFreq[n3] = this.m_mtfFreq[n3] + 1;
        this.m_nMTF = ++wr;
    }

    private void hbAssignCodes(int[] code, char[] length, int minLen, int maxLen, int alphaSize) {
        int vec = 0;
        for (int n2 = minLen; n2 <= maxLen; ++n2) {
            for (int i2 = 0; i2 < alphaSize; ++i2) {
                if (length[i2] != n2) continue;
                code[i2] = vec++;
            }
            vec <<= 1;
        }
    }

    private void initBlock() {
        this.m_crc.initialiseCRC();
        this.m_last = -1;
        for (int i2 = 0; i2 < 256; ++i2) {
            this.m_inUse[i2] = false;
        }
        this.m_allowableBlockSize = 100000 * this.m_blockSize100k - 20;
    }

    private void initialize() throws IOException {
        this.bsPutUChar(104);
        this.bsPutUChar(48 + this.m_blockSize100k);
        this.m_combinedCRC = 0;
    }

    private void mainSort() {
        int i2;
        int[] runningOrder = new int[256];
        int[] copy = new int[256];
        boolean[] bigDone = new boolean[256];
        for (i2 = 0; i2 < 20; ++i2) {
            this.m_block[this.m_last + i2 + 2] = this.m_block[i2 % (this.m_last + 1) + 1];
        }
        for (i2 = 0; i2 <= this.m_last + 20; ++i2) {
            this.m_quadrant[i2] = 0;
        }
        this.m_block[0] = this.m_block[this.m_last + 1];
        if (this.m_last < 4000) {
            for (i2 = 0; i2 <= this.m_last; ++i2) {
                this.m_zptr[i2] = i2;
            }
            this.m_firstAttempt = false;
            this.m_workDone = 0;
            this.m_workLimit = 0;
            this.simpleSort(0, this.m_last, 0);
        } else {
            int j2;
            char c2;
            for (i2 = 0; i2 <= 255; ++i2) {
                bigDone[i2] = false;
            }
            for (i2 = 0; i2 <= 65536; ++i2) {
                this.m_ftab[i2] = 0;
            }
            char c1 = this.m_block[0];
            for (i2 = 0; i2 <= this.m_last; ++i2) {
                c2 = this.m_block[i2 + 1];
                int n2 = (c1 << 8) + c2;
                this.m_ftab[n2] = this.m_ftab[n2] + 1;
                c1 = c2;
            }
            for (i2 = 1; i2 <= 65536; ++i2) {
                int n3 = i2;
                this.m_ftab[n3] = this.m_ftab[n3] + this.m_ftab[i2 - 1];
            }
            c1 = this.m_block[1];
            i2 = 0;
            while (i2 < this.m_last) {
                c2 = this.m_block[i2 + 2];
                j2 = (c1 << 8) + c2;
                c1 = c2;
                int n4 = j2;
                this.m_ftab[n4] = this.m_ftab[n4] - 1;
                this.m_zptr[this.m_ftab[j2]] = i2++;
            }
            int n5 = j2 = (this.m_block[this.m_last + 1] << 8) + this.m_block[1];
            this.m_ftab[n5] = this.m_ftab[n5] - 1;
            this.m_zptr[this.m_ftab[j2]] = this.m_last;
            for (i2 = 0; i2 <= 255; ++i2) {
                runningOrder[i2] = i2;
            }
            int h2 = 1;
            while ((h2 = 3 * h2 + 1) <= 256) {
            }
            do {
                for (i2 = h2 /= 3; i2 <= 255; ++i2) {
                    int vv = runningOrder[i2];
                    j2 = i2;
                    while (this.m_ftab[runningOrder[j2 - h2] + 1 << 8] - this.m_ftab[runningOrder[j2 - h2] << 8] > this.m_ftab[vv + 1 << 8] - this.m_ftab[vv << 8]) {
                        runningOrder[j2] = runningOrder[j2 - h2];
                        if ((j2 -= h2) > h2 - 1) continue;
                    }
                    runningOrder[j2] = vv;
                }
            } while (h2 != 1);
            for (i2 = 0; i2 <= 255; ++i2) {
                int ss = runningOrder[i2];
                for (j2 = 0; j2 <= 255; ++j2) {
                    int sb = (ss << 8) + j2;
                    if ((this.m_ftab[sb] & 0x200000) == 0x200000) continue;
                    int hi = (this.m_ftab[sb + 1] & 0xFFDFFFFF) - 1;
                    int lo = this.m_ftab[sb] & 0xFFDFFFFF;
                    if (hi > lo) {
                        this.qSort3(lo, hi, 2);
                        if (this.m_workDone > this.m_workLimit && this.m_firstAttempt) {
                            return;
                        }
                    }
                    int n6 = sb;
                    this.m_ftab[n6] = this.m_ftab[n6] | 0x200000;
                }
                bigDone[ss] = true;
                if (i2 < 255) {
                    int bbStart = this.m_ftab[ss << 8] & 0xFFDFFFFF;
                    int bbSize = (this.m_ftab[ss + 1 << 8] & 0xFFDFFFFF) - bbStart;
                    int shifts = 0;
                    while (bbSize >> shifts > 65534) {
                        ++shifts;
                    }
                    for (j2 = 0; j2 < bbSize; ++j2) {
                        int qVal;
                        int a2update = this.m_zptr[bbStart + j2];
                        this.m_quadrant[a2update] = qVal = j2 >> shifts;
                        if (a2update >= 20) continue;
                        this.m_quadrant[a2update + this.m_last + 1] = qVal;
                    }
                    if (bbSize - 1 >> shifts > 65535) {
                        CBZip2OutputStream.panic();
                    }
                }
                for (j2 = 0; j2 <= 255; ++j2) {
                    copy[j2] = this.m_ftab[(j2 << 8) + ss] & 0xFFDFFFFF;
                }
                for (j2 = this.m_ftab[ss << 8] & 0xFFDFFFFF; j2 < (this.m_ftab[ss + 1 << 8] & 0xFFDFFFFF); ++j2) {
                    c1 = this.m_block[this.m_zptr[j2]];
                    if (bigDone[c1]) continue;
                    this.m_zptr[copy[c1]] = this.m_zptr[j2] == 0 ? this.m_last : this.m_zptr[j2] - 1;
                    char c3 = c1;
                    copy[c3] = copy[c3] + 1;
                }
                for (j2 = 0; j2 <= 255; ++j2) {
                    int n7 = (j2 << 8) + ss;
                    this.m_ftab[n7] = this.m_ftab[n7] | 0x200000;
                }
            }
        }
    }

    private void makeMaps() {
        this.m_nInUse = 0;
        for (int i2 = 0; i2 < 256; ++i2) {
            if (!this.m_inUse[i2]) continue;
            this.m_seqToUnseq[this.m_nInUse] = (char)i2;
            this.m_unseqToSeq[i2] = (char)this.m_nInUse;
            ++this.m_nInUse;
        }
    }

    private char med3(char a2, char b2, char c2) {
        char t2;
        if (a2 > b2) {
            t2 = a2;
            a2 = b2;
            b2 = t2;
        }
        if (b2 > c2) {
            t2 = b2;
            b2 = c2;
            c2 = t2;
        }
        if (a2 > b2) {
            b2 = a2;
        }
        return b2;
    }

    private void moveToFrontCodeAndSend() throws IOException {
        this.bsPutIntVS(24, this.m_origPtr);
        this.generateMTFValues();
        this.sendMTFValues();
    }

    private void qSort3(int loSt, int hiSt, int dSt) {
        StackElem[] stack = new StackElem[1000];
        for (int count = 0; count < 1000; ++count) {
            stack[count] = new StackElem();
        }
        int sp = 0;
        stack[sp].m_ll = loSt;
        stack[sp].m_hh = hiSt;
        stack[sp].m_dd = dSt;
        ++sp;
        while (sp > 0) {
            int n2;
            if (sp >= 1000) {
                CBZip2OutputStream.panic();
            }
            int lo = stack[--sp].m_ll;
            int hi = stack[sp].m_hh;
            int d2 = stack[sp].m_dd;
            if (hi - lo < 20 || d2 > 10) {
                this.simpleSort(lo, hi, d2);
                if (this.m_workDone <= this.m_workLimit || !this.m_firstAttempt) continue;
                return;
            }
            char med = this.med3(this.m_block[this.m_zptr[lo] + d2 + 1], this.m_block[this.m_zptr[hi] + d2 + 1], this.m_block[this.m_zptr[lo + hi >> 1] + d2 + 1]);
            int unLo = lo;
            int ltLo = lo;
            int unHi = hi;
            int gtHi = hi;
            while (true) {
                int temp;
                if (unLo <= unHi) {
                    n2 = this.m_block[this.m_zptr[unLo] + d2 + 1] - med;
                    if (n2 == 0) {
                        temp = 0;
                        temp = this.m_zptr[unLo];
                        this.m_zptr[unLo] = this.m_zptr[ltLo];
                        this.m_zptr[ltLo] = temp;
                        ++ltLo;
                        ++unLo;
                        continue;
                    }
                    if (n2 <= 0) {
                        ++unLo;
                        continue;
                    }
                }
                while (unLo <= unHi) {
                    n2 = this.m_block[this.m_zptr[unHi] + d2 + 1] - med;
                    if (n2 == 0) {
                        temp = 0;
                        temp = this.m_zptr[unHi];
                        this.m_zptr[unHi] = this.m_zptr[gtHi];
                        this.m_zptr[gtHi] = temp;
                        --gtHi;
                        --unHi;
                        continue;
                    }
                    if (n2 < 0) break;
                    --unHi;
                }
                if (unLo > unHi) break;
                temp = 0;
                temp = this.m_zptr[unLo];
                this.m_zptr[unLo] = this.m_zptr[unHi];
                this.m_zptr[unHi] = temp;
                ++unLo;
                --unHi;
            }
            if (gtHi < ltLo) {
                stack[sp].m_ll = lo;
                stack[sp].m_hh = hi;
                stack[sp].m_dd = d2 + 1;
                ++sp;
                continue;
            }
            n2 = ltLo - lo < unLo - ltLo ? ltLo - lo : unLo - ltLo;
            this.vswap(lo, unLo - n2, n2);
            int m2 = hi - gtHi < gtHi - unHi ? hi - gtHi : gtHi - unHi;
            this.vswap(unLo, hi - m2 + 1, m2);
            n2 = lo + unLo - ltLo - 1;
            m2 = hi - (gtHi - unHi) + 1;
            stack[sp].m_ll = lo;
            stack[sp].m_hh = n2;
            stack[sp].m_dd = d2;
            stack[++sp].m_ll = n2 + 1;
            stack[sp].m_hh = m2 - 1;
            stack[sp].m_dd = d2 + 1;
            stack[++sp].m_ll = m2;
            stack[sp].m_hh = hi;
            stack[sp].m_dd = d2;
            ++sp;
        }
    }

    private void randomiseBlock() {
        int i2;
        int rNToGo = 0;
        int rTPos = 0;
        for (i2 = 0; i2 < 256; ++i2) {
            this.m_inUse[i2] = false;
        }
        for (i2 = 0; i2 <= this.m_last; ++i2) {
            if (rNToGo == 0) {
                rNToGo = (char)RAND_NUMS[rTPos];
                if (++rTPos == 512) {
                    rTPos = 0;
                }
            }
            int n2 = i2 + 1;
            this.m_block[n2] = (char)(this.m_block[n2] ^ (--rNToGo == 1 ? (char)'\u0001' : '\u0000'));
            int n3 = i2 + 1;
            this.m_block[n3] = (char)(this.m_block[n3] & 0xFF);
            this.m_inUse[this.m_block[i2 + 1]] = true;
        }
    }

    private void sendMTFValues() throws IOException {
        int j2;
        int i2;
        int v2;
        int ge;
        int t2;
        char[][] len = new char[6][258];
        int nSelectors = 0;
        int alphaSize = this.m_nInUse + 2;
        for (t2 = 0; t2 < 6; ++t2) {
            for (int v22 = 0; v22 < alphaSize; ++v22) {
                len[t2][v22] = 15;
            }
        }
        if (this.m_nMTF <= 0) {
            CBZip2OutputStream.panic();
        }
        int nGroups = this.m_nMTF < 200 ? 2 : (this.m_nMTF < 600 ? 3 : (this.m_nMTF < 1200 ? 4 : (this.m_nMTF < 2400 ? 5 : 6)));
        int nPart = nGroups;
        int remF = this.m_nMTF;
        int gs = 0;
        while (nPart > 0) {
            int aFreq;
            int tFreq = remF / nPart;
            ge = gs - 1;
            for (aFreq = 0; aFreq < tFreq && ge < alphaSize - 1; aFreq += this.m_mtfFreq[++ge]) {
            }
            if (ge > gs && nPart != nGroups && nPart != 1 && (nGroups - nPart) % 2 == 1) {
                aFreq -= this.m_mtfFreq[ge];
                --ge;
            }
            for (v2 = 0; v2 < alphaSize; ++v2) {
                len[nPart - 1][v2] = v2 >= gs && v2 <= ge ? 0 : 15;
            }
            --nPart;
            gs = ge + 1;
            remF -= aFreq;
        }
        int[][] rfreq = new int[6][258];
        int[] fave = new int[6];
        short[] cost = new short[6];
        for (int iter = 0; iter < 4; ++iter) {
            for (t2 = 0; t2 < nGroups; ++t2) {
                fave[t2] = 0;
            }
            for (t2 = 0; t2 < nGroups; ++t2) {
                for (v2 = 0; v2 < alphaSize; ++v2) {
                    rfreq[t2][v2] = 0;
                }
            }
            nSelectors = 0;
            gs = 0;
            while (gs < this.m_nMTF) {
                int i3;
                ge = gs + 50 - 1;
                if (ge >= this.m_nMTF) {
                    ge = this.m_nMTF - 1;
                }
                for (t2 = 0; t2 < nGroups; ++t2) {
                    cost[t2] = 0;
                }
                if (nGroups == 6) {
                    short cost0 = 0;
                    short cost1 = 0;
                    short cost2 = 0;
                    short cost3 = 0;
                    short cost4 = 0;
                    short cost5 = 0;
                    for (i3 = gs; i3 <= ge; ++i3) {
                        short icv = this.m_szptr[i3];
                        cost0 = (short)(cost0 + len[0][icv]);
                        cost1 = (short)(cost1 + len[1][icv]);
                        cost2 = (short)(cost2 + len[2][icv]);
                        cost3 = (short)(cost3 + len[3][icv]);
                        cost4 = (short)(cost4 + len[4][icv]);
                        cost5 = (short)(cost5 + len[5][icv]);
                    }
                    cost[0] = cost0;
                    cost[1] = cost1;
                    cost[2] = cost2;
                    cost[3] = cost3;
                    cost[4] = cost4;
                    cost[5] = cost5;
                } else {
                    for (i3 = gs; i3 <= ge; ++i3) {
                        short icv = this.m_szptr[i3];
                        for (t2 = 0; t2 < nGroups; ++t2) {
                            int n2 = t2;
                            cost[n2] = (short)(cost[n2] + len[t2][icv]);
                        }
                    }
                }
                short s2 = 999999999;
                int bt = -1;
                for (t2 = 0; t2 < nGroups; ++t2) {
                    if (cost[t2] >= s2) continue;
                    s2 = cost[t2];
                    bt = t2;
                }
                int n3 = bt;
                fave[n3] = fave[n3] + 1;
                this.m_selector[nSelectors] = (char)bt;
                ++nSelectors;
                for (i3 = gs; i3 <= ge; ++i3) {
                    int[] nArray = rfreq[bt];
                    short s3 = this.m_szptr[i3];
                    nArray[s3] = nArray[s3] + 1;
                }
                gs = ge + 1;
            }
            for (t2 = 0; t2 < nGroups; ++t2) {
                CBZip2OutputStream.hbMakeCodeLengths(len[t2], rfreq[t2], alphaSize, 20);
            }
        }
        rfreq = null;
        fave = null;
        cost = null;
        if (nGroups >= 8) {
            CBZip2OutputStream.panic();
        }
        if (nSelectors >= 32768 || nSelectors > 18002) {
            CBZip2OutputStream.panic();
        }
        char[] pos = new char[6];
        for (i2 = 0; i2 < nGroups; ++i2) {
            pos[i2] = (char)i2;
        }
        for (i2 = 0; i2 < nSelectors; ++i2) {
            char ll_i = this.m_selector[i2];
            int j22 = 0;
            char tmp = pos[j22];
            while (ll_i != tmp) {
                char tmp2 = tmp;
                tmp = pos[++j22];
                pos[j22] = tmp2;
            }
            pos[0] = tmp;
            this.m_selectorMtf[i2] = (char)j22;
        }
        int[][] code = new int[6][258];
        for (t2 = 0; t2 < nGroups; ++t2) {
            char minLen = ' ';
            char maxLen = '\u0000';
            for (i2 = 0; i2 < alphaSize; ++i2) {
                if (len[t2][i2] > maxLen) {
                    maxLen = len[t2][i2];
                }
                if (len[t2][i2] >= minLen) continue;
                minLen = len[t2][i2];
            }
            if (maxLen > '\u0014') {
                CBZip2OutputStream.panic();
            }
            if (minLen < '\u0001') {
                CBZip2OutputStream.panic();
            }
            this.hbAssignCodes(code[t2], len[t2], minLen, maxLen, alphaSize);
        }
        boolean[] inUse16 = new boolean[16];
        for (i2 = 0; i2 < 16; ++i2) {
            inUse16[i2] = false;
            for (j2 = 0; j2 < 16; ++j2) {
                if (!this.m_inUse[i2 * 16 + j2]) continue;
                inUse16[i2] = true;
            }
        }
        for (i2 = 0; i2 < 16; ++i2) {
            if (inUse16[i2]) {
                this.bsW(1, 1);
                continue;
            }
            this.bsW(1, 0);
        }
        for (i2 = 0; i2 < 16; ++i2) {
            if (!inUse16[i2]) continue;
            for (j2 = 0; j2 < 16; ++j2) {
                if (this.m_inUse[i2 * 16 + j2]) {
                    this.bsW(1, 1);
                    continue;
                }
                this.bsW(1, 0);
            }
        }
        this.bsW(3, nGroups);
        this.bsW(15, nSelectors);
        for (i2 = 0; i2 < nSelectors; ++i2) {
            for (j2 = 0; j2 < this.m_selectorMtf[i2]; ++j2) {
                this.bsW(1, 1);
            }
            this.bsW(1, 0);
        }
        for (t2 = 0; t2 < nGroups; ++t2) {
            int curr = len[t2][0];
            this.bsW(5, curr);
            for (i2 = 0; i2 < alphaSize; ++i2) {
                while (curr < len[t2][i2]) {
                    this.bsW(2, 2);
                    ++curr;
                }
                while (curr > len[t2][i2]) {
                    this.bsW(2, 3);
                    --curr;
                }
                this.bsW(1, 0);
            }
        }
        int selCtr = 0;
        gs = 0;
        while (gs < this.m_nMTF) {
            ge = gs + 50 - 1;
            if (ge >= this.m_nMTF) {
                ge = this.m_nMTF - 1;
            }
            for (i2 = gs; i2 <= ge; ++i2) {
                this.bsW(len[this.m_selector[selCtr]][this.m_szptr[i2]], code[this.m_selector[selCtr]][this.m_szptr[i2]]);
            }
            gs = ge + 1;
            ++selCtr;
        }
        if (selCtr != nSelectors) {
            CBZip2OutputStream.panic();
        }
    }

    private void simpleSort(int lo, int hi, int d2) {
        int bigN = hi - lo + 1;
        if (bigN < 2) {
            return;
        }
        int hp = 0;
        while (this.m_incs[hp] < bigN) {
            ++hp;
        }
        --hp;
        while (hp >= 0) {
            int h2 = this.m_incs[hp];
            for (int i2 = lo + h2; i2 <= hi; ++i2) {
                int v2 = this.m_zptr[i2];
                int j2 = i2;
                while (this.fullGtU(this.m_zptr[j2 - h2] + d2, v2 + d2)) {
                    this.m_zptr[j2] = this.m_zptr[j2 - h2];
                    if ((j2 -= h2) > lo + h2 - 1) continue;
                }
                this.m_zptr[j2] = v2;
                if (++i2 > hi) break;
                v2 = this.m_zptr[i2];
                j2 = i2;
                while (this.fullGtU(this.m_zptr[j2 - h2] + d2, v2 + d2)) {
                    this.m_zptr[j2] = this.m_zptr[j2 - h2];
                    if ((j2 -= h2) > lo + h2 - 1) continue;
                }
                this.m_zptr[j2] = v2;
                if (++i2 > hi) break;
                v2 = this.m_zptr[i2];
                j2 = i2;
                while (this.fullGtU(this.m_zptr[j2 - h2] + d2, v2 + d2)) {
                    this.m_zptr[j2] = this.m_zptr[j2 - h2];
                    if ((j2 -= h2) > lo + h2 - 1) continue;
                }
                this.m_zptr[j2] = v2;
                if (this.m_workDone <= this.m_workLimit || !this.m_firstAttempt) continue;
                return;
            }
            --hp;
        }
    }

    private void vswap(int p1, int p2, int n2) {
        int temp = 0;
        while (n2 > 0) {
            temp = this.m_zptr[p1];
            this.m_zptr[p1] = this.m_zptr[p2];
            this.m_zptr[p2] = temp;
            ++p1;
            ++p2;
            --n2;
        }
    }

    private void writeRun() throws IOException {
        if (this.m_last < this.m_allowableBlockSize) {
            this.m_inUse[this.m_currentChar] = true;
            for (int i2 = 0; i2 < this.m_runLength; ++i2) {
                this.m_crc.updateCRC((char)this.m_currentChar);
            }
            switch (this.m_runLength) {
                case 1: {
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    break;
                }
                case 2: {
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    break;
                }
                case 3: {
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    break;
                }
                default: {
                    this.m_inUse[this.m_runLength - 4] = true;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)(this.m_runLength - 4);
                    break;
                }
            }
        } else {
            this.endBlock();
            this.initBlock();
            this.writeRun();
        }
    }

    private static class StackElem {
        int m_dd;
        int m_hh;
        int m_ll;

        private StackElem() {
        }
    }
}

