/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.local;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.AbstractRandomAccessContent;
import org.apache.commons.vfs.util.RandomAccessMode;

class LocalFileRandomAccessContent
extends AbstractRandomAccessContent {
    private final RandomAccessFile raf;
    private final InputStream rafis;

    LocalFileRandomAccessContent(File localFile, RandomAccessMode mode) throws FileSystemException {
        super(mode);
        StringBuffer modes = new StringBuffer(2);
        if (mode.requestRead()) {
            modes.append('r');
        }
        if (mode.requestWrite()) {
            modes.append('w');
        }
        try {
            this.raf = new RandomAccessFile(localFile, modes.toString());
            this.rafis = new InputStream(){

                public int read() throws IOException {
                    try {
                        return LocalFileRandomAccessContent.this.raf.readByte();
                    }
                    catch (EOFException e2) {
                        return -1;
                    }
                }

                public long skip(long n2) throws IOException {
                    LocalFileRandomAccessContent.this.raf.seek(LocalFileRandomAccessContent.this.raf.getFilePointer() + n2);
                    return n2;
                }

                public void close() throws IOException {
                    LocalFileRandomAccessContent.this.raf.close();
                }

                public int read(byte[] b2) throws IOException {
                    return LocalFileRandomAccessContent.this.raf.read(b2);
                }

                public int read(byte[] b2, int off, int len) throws IOException {
                    return LocalFileRandomAccessContent.this.raf.read(b2, off, len);
                }

                public int available() throws IOException {
                    long available = LocalFileRandomAccessContent.this.raf.length() - LocalFileRandomAccessContent.this.raf.getFilePointer();
                    if (available > Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    return (int)available;
                }
            };
        }
        catch (FileNotFoundException e2) {
            throw new FileSystemException("vfs.provider/random-access-open-failed.error", localFile);
        }
    }

    public long getFilePointer() throws IOException {
        return this.raf.getFilePointer();
    }

    public void seek(long pos) throws IOException {
        this.raf.seek(pos);
    }

    public long length() throws IOException {
        return this.raf.length();
    }

    public void close() throws IOException {
        this.raf.close();
    }

    public byte readByte() throws IOException {
        return this.raf.readByte();
    }

    public char readChar() throws IOException {
        return this.raf.readChar();
    }

    public double readDouble() throws IOException {
        return this.raf.readDouble();
    }

    public float readFloat() throws IOException {
        return this.raf.readFloat();
    }

    public int readInt() throws IOException {
        return this.raf.readInt();
    }

    public int readUnsignedByte() throws IOException {
        return this.raf.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.raf.readUnsignedShort();
    }

    public long readLong() throws IOException {
        return this.raf.readLong();
    }

    public short readShort() throws IOException {
        return this.raf.readShort();
    }

    public boolean readBoolean() throws IOException {
        return this.raf.readBoolean();
    }

    public int skipBytes(int n2) throws IOException {
        return this.raf.skipBytes(n2);
    }

    public void readFully(byte[] b2) throws IOException {
        this.raf.readFully(b2);
    }

    public void readFully(byte[] b2, int off, int len) throws IOException {
        this.raf.readFully(b2, off, len);
    }

    public String readUTF() throws IOException {
        return this.raf.readUTF();
    }

    public void writeDouble(double v2) throws IOException {
        this.raf.writeDouble(v2);
    }

    public void writeFloat(float v2) throws IOException {
        this.raf.writeFloat(v2);
    }

    public void write(int b2) throws IOException {
        this.raf.write(b2);
    }

    public void writeByte(int v2) throws IOException {
        this.raf.writeByte(v2);
    }

    public void writeChar(int v2) throws IOException {
        this.raf.writeChar(v2);
    }

    public void writeInt(int v2) throws IOException {
        this.raf.writeInt(v2);
    }

    public void writeShort(int v2) throws IOException {
        this.raf.writeShort(v2);
    }

    public void writeLong(long v2) throws IOException {
        this.raf.writeLong(v2);
    }

    public void writeBoolean(boolean v2) throws IOException {
        this.raf.writeBoolean(v2);
    }

    public void write(byte[] b2) throws IOException {
        this.raf.write(b2);
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        this.raf.write(b2, off, len);
    }

    public void writeBytes(String s2) throws IOException {
        this.raf.writeBytes(s2);
    }

    public void writeChars(String s2) throws IOException {
        this.raf.writeChars(s2);
    }

    public void writeUTF(String str) throws IOException {
        this.raf.writeUTF(str);
    }

    public InputStream getInputStream() throws IOException {
        return this.rafis;
    }
}

