/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.url;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.URLFileName;
import org.apache.commons.vfs.provider.url.UrlFileSystem;

public class UrlFileObject
extends AbstractFileObject
implements FileObject {
    private URL url;

    protected UrlFileObject(UrlFileSystem fs, FileName fileName) {
        super(fileName, fs);
    }

    protected void doAttach() throws Exception {
        if (this.url == null) {
            this.url = this.createURL(this.getName());
        }
    }

    protected URL createURL(FileName name) throws MalformedURLException, FileSystemException, URIException {
        if (name instanceof URLFileName) {
            URLFileName urlName = (URLFileName)this.getName();
            return new URL(urlName.getURIEncoded(null));
        }
        return new URL(this.getName().getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected FileType doGetType() throws Exception {
        try {
            URLConnection conn = this.url.openConnection();
            InputStream in = conn.getInputStream();
            try {
                int status;
                if (conn instanceof HttpURLConnection && 200 != (status = ((HttpURLConnection)conn).getResponseCode())) {
                    FileType fileType = FileType.IMAGINARY;
                    return fileType;
                }
                FileType fileType = FileType.FILE;
                return fileType;
            }
            finally {
                in.close();
            }
        }
        catch (FileNotFoundException e2) {
            return FileType.IMAGINARY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long doGetContentSize() throws Exception {
        URLConnection conn = this.url.openConnection();
        InputStream in = conn.getInputStream();
        try {
            long l2 = conn.getContentLength();
            return l2;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long doGetLastModifiedTime() throws Exception {
        URLConnection conn = this.url.openConnection();
        InputStream in = conn.getInputStream();
        try {
            long l2 = conn.getLastModified();
            return l2;
        }
        finally {
            in.close();
        }
    }

    protected String[] doListChildren() throws Exception {
        throw new FileSystemException("Not implemented.");
    }

    protected InputStream doGetInputStream() throws Exception {
        return this.url.openStream();
    }
}

