/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.tasks;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.tasks.VfsTask;
import org.apache.commons.vfs.util.Messages;
import org.apache.tools.ant.BuildException;

public class MkdirTask
extends VfsTask {
    private String dirName;

    public void setDir(String dir) {
        this.dirName = dir;
    }

    public void execute() throws BuildException {
        if (this.dirName == null) {
            String message = Messages.getString("vfs.tasks/no-directory-specified.error");
            throw new BuildException(message);
        }
        try {
            FileObject dir = this.resolveFile(this.dirName);
            String message = Messages.getString("vfs.tasks/mkdir.create-folder.info", dir);
            this.log(message);
            dir.createFolder();
        }
        catch (FileSystemException e2) {
            throw new BuildException((Throwable)e2);
        }
    }
}

