/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.el.impl.parser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jdesktop.el.ELContext;
import org.jdesktop.el.ELException;
import org.jdesktop.el.FunctionMapper;
import org.jdesktop.el.impl.lang.EvaluationContext;
import org.jdesktop.el.impl.parser.ELParserTreeConstants;
import org.jdesktop.el.impl.parser.SimpleNode;
import org.jdesktop.el.impl.util.MessageFactory;

public final class AstFunction
extends SimpleNode {
    protected String localName = "";
    protected String prefix = "";

    public AstFunction(int id) {
        super(id);
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getOutputName() {
        if (this.prefix == null) {
            return this.localName;
        }
        return this.prefix + ":" + this.localName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Class getType(EvaluationContext ctx) throws ELException {
        FunctionMapper fnMapper = ctx.getFunctionMapper();
        if (fnMapper == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.null"));
        }
        Method m2 = fnMapper.resolveFunction(this.prefix, this.localName);
        if (m2 == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.method", this.getOutputName()));
        }
        return m2.getReturnType();
    }

    public Object getValue(EvaluationContext ctx) throws ELException {
        FunctionMapper fnMapper = ctx.getFunctionMapper();
        if (fnMapper == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.null"));
        }
        Method m2 = fnMapper.resolveFunction(this.prefix, this.localName);
        if (m2 == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.method", this.getOutputName()));
        }
        Class<?>[] paramTypes = m2.getParameterTypes();
        Object[] params = null;
        Object result = null;
        int numParams = this.jjtGetNumChildren();
        if (numParams > 0) {
            params = new Object[numParams];
            try {
                for (int i2 = 0; i2 < numParams; ++i2) {
                    params[i2] = this.children[i2].getValue(ctx);
                    if (params[i2] == ELContext.UNRESOLVABLE_RESULT) {
                        return ELContext.UNRESOLVABLE_RESULT;
                    }
                    params[i2] = AstFunction.coerceToType(params[i2], paramTypes[i2]);
                }
            }
            catch (ELException ele) {
                throw new ELException(MessageFactory.get("error.function", this.getOutputName()), ele);
            }
        }
        try {
            result = m2.invoke(null, params);
        }
        catch (IllegalAccessException iae) {
            throw new ELException(MessageFactory.get("error.function", this.getOutputName()), iae);
        }
        catch (InvocationTargetException ite) {
            throw new ELException(MessageFactory.get("error.function", this.getOutputName()), ite.getCause());
        }
        return result;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String toString() {
        return ELParserTreeConstants.jjtNodeName[this.id] + "[" + this.getOutputName() + "]";
    }
}

