/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.el.impl.parser;

import org.jdesktop.el.ELException;
import org.jdesktop.el.MethodInfo;
import org.jdesktop.el.PropertyNotWritableException;
import org.jdesktop.el.impl.lang.ELSupport;
import org.jdesktop.el.impl.lang.EvaluationContext;
import org.jdesktop.el.impl.parser.ELParserTreeConstants;
import org.jdesktop.el.impl.parser.Node;
import org.jdesktop.el.impl.parser.NodeVisitor;
import org.jdesktop.el.impl.util.MessageFactory;

public abstract class SimpleNode
extends ELSupport
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected String image;

    public SimpleNode(int i2) {
        this.id = i2;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node n2) {
        this.parent = n2;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node n2, int i2) {
        if (this.children == null) {
            this.children = new Node[i2 + 1];
        } else if (i2 >= this.children.length) {
            Node[] c2 = new Node[i2 + 1];
            System.arraycopy(this.children, 0, c2, 0, this.children.length);
            this.children = c2;
        }
        this.children[i2] = n2;
    }

    public Node jjtGetChild(int i2) {
        return this.children[i2];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        if (this.image != null) {
            return ELParserTreeConstants.jjtNodeName[this.id] + "[" + this.image + "]";
        }
        return ELParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (int i2 = 0; i2 < this.children.length; ++i2) {
                SimpleNode n2 = (SimpleNode)this.children[i2];
                if (n2 == null) continue;
                n2.dump(prefix + " ");
            }
        }
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public Class getType(EvaluationContext ctx) throws ELException {
        throw new UnsupportedOperationException();
    }

    public Object getValue(EvaluationContext ctx) throws ELException {
        throw new UnsupportedOperationException();
    }

    public boolean isReadOnly(EvaluationContext ctx) throws ELException {
        return true;
    }

    public void setValue(EvaluationContext ctx, Object value) throws ELException {
        throw new PropertyNotWritableException(MessageFactory.get("error.syntax.set"));
    }

    public void accept(NodeVisitor visitor) throws ELException {
        visitor.visit(this);
        if (this.children != null && this.children.length > 0) {
            for (int i2 = 0; i2 < this.children.length; ++i2) {
                this.children[i2].accept(visitor);
            }
        }
    }

    public Object invoke(EvaluationContext ctx, Class[] paramTypes, Object[] paramValues) throws ELException {
        throw new UnsupportedOperationException();
    }

    public MethodInfo getMethodInfo(EvaluationContext ctx, Class[] paramTypes) throws ELException {
        throw new UnsupportedOperationException();
    }
}

