/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.calendar;

import java.util.Date;

public class DateSpan {
    private long _start;
    private long _end;

    public DateSpan(long start, long end) {
        this._start = start;
        this._end = end;
        if (this._start > this._end) {
            throw new IllegalArgumentException("Start date must be before end date");
        }
    }

    public DateSpan(Date start, Date end) {
        this(start.getTime(), end.getTime());
    }

    public long getStart() {
        return this._start;
    }

    public long getEnd() {
        return this._end;
    }

    public Date getStartAsDate() {
        return new Date(this.getStart());
    }

    public Date getEndAsDate() {
        return new Date(this.getEnd());
    }

    public boolean contains(DateSpan span) {
        return this.contains(span.getStart()) && this.contains(span.getEnd());
    }

    public boolean contains(long time) {
        return time >= this.getStart() && time <= this.getEnd();
    }

    public boolean contains(long start, long end) {
        return start >= this.getStart() && end <= this.getEnd();
    }

    public boolean intersects(long start, long end) {
        return start <= this.getEnd() && end >= this.getStart();
    }

    public boolean intersects(DateSpan span) {
        return this.intersects(span.getStart(), span.getEnd());
    }

    public DateSpan add(DateSpan span) {
        return this.add(span.getStart(), span.getEnd());
    }

    public DateSpan add(long start, long end) {
        return new DateSpan(Math.min(start, this.getStart()), Math.max(end, this.getEnd()));
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (o2 instanceof DateSpan) {
            DateSpan ds = (DateSpan)o2;
            return this._start == ds.getStart() && this._end == ds.getEnd();
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (int)(this._start ^ this._start >>> 32);
        result = 37 * result + (int)(this._end ^ this._end >>> 32);
        return result;
    }

    public String toString() {
        return "DateSpan [" + this.getStartAsDate() + "-" + this.getEndAsDate() + "]";
    }
}

