/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.painter.AbstractPainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TextCrossingPainter<T extends JComponent>
extends AbstractPainter<T> {
    Rectangle paintIconR = new Rectangle();
    Rectangle paintViewR = new Rectangle();
    Rectangle paintTextR = new Rectangle();
    Insets insetss = new Insets(0, 0, 0, 0);
    Color crossColor;

    TextCrossingPainter() {
    }

    @Override
    protected void doPaint(Graphics2D g2, JComponent comp, int width, int height) {
        if (!(comp instanceof JLabel)) {
            return;
        }
        JLabel label = (JLabel)comp;
        Insets insets = label.getInsets(this.insetss);
        this.paintViewR.x = insets.left;
        this.paintViewR.y = insets.top;
        this.paintViewR.width = width - (insets.left + insets.right);
        this.paintViewR.height = height - (insets.top + insets.bottom);
        this.paintIconR.height = 0;
        this.paintIconR.width = 0;
        this.paintIconR.y = 0;
        this.paintIconR.x = 0;
        this.paintTextR.height = 0;
        this.paintTextR.width = 0;
        this.paintTextR.y = 0;
        this.paintTextR.x = 0;
        SwingUtilities.layoutCompoundLabel(label, label.getFontMetrics(label.getFont()), label.getText(), null, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), this.paintViewR, this.paintIconR, this.paintTextR, label.getIconTextGap());
        this.doPaint(g2, this.paintTextR);
    }

    private void doPaint(Graphics2D g2, Rectangle r2) {
        Color old = g2.getColor();
        g2.setColor(this.getForeground());
        g2.drawLine(r2.x, r2.y, r2.x + r2.width, r2.y + r2.height);
        g2.drawLine(r2.x + 1, r2.y, r2.x + r2.width + 1, r2.y + r2.height);
        g2.drawLine(r2.x + r2.width, r2.y, r2.x, r2.y + r2.height);
        g2.drawLine(r2.x + r2.width - 1, r2.y, r2.x - 1, r2.y + r2.height);
        g2.setColor(old);
    }

    public void setForeground(Color crossColor) {
        Color old = this.getForeground();
        this.crossColor = crossColor;
        this.firePropertyChange("foreground", old, this.getForeground());
    }

    public Color getForeground() {
        return this.crossColor;
    }
}

