/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.synth;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;

public class SynthUtils {
    private static SynthPainter NULL_PAINTER = new SynthPainter(){};

    public static SynthContext getContext(JComponent c2, Region region, SynthStyle style, int state) {
        return new SynthContext(c2, region, style, state);
    }

    public static SynthContext getContext(SynthContext context, SynthStyle style) {
        if (context.getStyle().equals(style)) {
            return context;
        }
        return SynthUtils.getContext(context.getComponent(), context.getRegion(), style, context.getComponentState());
    }

    public static SynthContext getContext(SynthContext context, int state) {
        if (context.getComponentState() == state) {
            return context;
        }
        return SynthUtils.getContext(context.getComponent(), context.getRegion(), context.getStyle(), state);
    }

    public static SynthPainter getPainter(SynthContext context) {
        SynthPainter painter = context.getStyle().getPainter(context);
        return painter != null ? painter : NULL_PAINTER;
    }

    public static boolean shouldUpdateStyle(PropertyChangeEvent event) {
        String eName = event.getPropertyName();
        if ("name" == eName) {
            return true;
        }
        if ("componentOrientation" == eName) {
            return true;
        }
        if ("ancestor" == eName && event.getNewValue() != null) {
            LookAndFeel laf = UIManager.getLookAndFeel();
            return laf instanceof SynthLookAndFeel && ((SynthLookAndFeel)laf).shouldUpdateStyleOnAncestorChanged();
        }
        if ("Nimbus.Overrides" == eName) {
            return true;
        }
        if ("Nimbus.Overrides.InheritDefaults" == eName) {
            return true;
        }
        return "JComponent.sizeVariant" == eName;
    }

    public static int getComponentState(JComponent c2) {
        if (c2.isEnabled()) {
            if (c2.isFocusOwner()) {
                return 257;
            }
            return 1;
        }
        return 8;
    }

    public static void update(SynthContext context, Graphics g2) {
        SynthUtils.update(context, g2, null);
    }

    public static void update(SynthContext context, Graphics g2, Rectangle bounds) {
        int height;
        int width;
        int y2;
        int x2;
        JComponent c2 = context.getComponent();
        SynthStyle style = context.getStyle();
        if (bounds == null) {
            x2 = 0;
            y2 = 0;
            width = c2.getWidth();
            height = c2.getHeight();
        } else {
            x2 = bounds.x;
            y2 = bounds.y;
            width = bounds.width;
            height = bounds.height;
        }
        boolean subregion = context.getRegion().isSubregion();
        if (subregion && style.isOpaque(context) || !subregion && c2.isOpaque()) {
            g2.setColor(style.getColor(context, ColorType.BACKGROUND));
            g2.fillRect(x2, y2, width, height);
        }
    }
}

